/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Xcss2EcssConverter {
    private Xcss2EcssConverter() {
    }

    public static void main(String[] args) throws SAXException, ParserConfigurationException, IOException {
        Handler handler = new Handler();
        CreateParser parser = new CreateParser(handler);
        String filename = args[0];
        parser.parse(filename);
    }

    public static class FilterReader
    extends java.io.FilterReader {
        public FilterReader(Reader in) {
            super(in);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.parse(this.toInputStream(in), baos);
                this.in = new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "utf-8");
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading xcss content : " + e.toString(), e);
            }
            catch (SAXException e) {
                throw new RuntimeException("Error while reading xml xcss content : " + e.toString(), e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Error while parsing xml xcss content : " + e.toString(), e);
            }
        }

        private InputStream toInputStream(Reader in) throws IOException {
            return this.toInputStream(this.toString(in));
        }

        private String toString(Reader in) throws IOException {
            int numRead;
            StringBuilder builder = new StringBuilder(1000);
            char[] buf = new char[1024];
            while ((numRead = in.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                builder.append(readData);
            }
            in.close();
            return builder.toString();
        }

        private InputStream toInputStream(String value) {
            try {
                return new ByteArrayInputStream(value.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("unexpected exception, utf-8 encoding should be supported : " + e, e);
            }
        }

        private void parse(InputStream inputStream, OutputStream outputStream) throws SAXException, ParserConfigurationException, IOException {
            Handler handler = new Handler(outputStream);
            CreateParser parser = new CreateParser(handler);
            parser.parse(inputStream);
        }
    }

    public static class CreateParser {
        private DefaultHandler handler;
        private SAXParser saxParser;

        public CreateParser(DefaultHandler handler) throws SAXException, ParserConfigurationException {
            this.handler = handler;
            this.create();
        }

        private void create() throws SAXException, ParserConfigurationException {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.saxParser = factory.newSAXParser();
        }

        public void parse(File file) throws IOException, SAXException {
            this.saxParser.parse(file, this.handler);
        }

        public void parse(String uri) throws IOException, SAXException {
            this.saxParser.parse(uri, this.handler);
        }

        public void parse(InputStream stream) throws IOException, SAXException {
            this.saxParser.parse(stream, this.handler);
        }
    }

    public static class Handler
    extends DefaultHandler {
        private static final String TEMPLATE = "template";
        private static final String SELECTOR = "selector";
        private static final String STYLE = "style";
        private static final String RESOURCE = "resource";
        private static final String ATTRIBUTE = "attribute";
        private static final String VERBATIM = "verbatim";
        private static final String IMPORT = "importResource";
        private static final String IF = "if";
        private StringBuilder ecssContent;
        private StringBuilder currentCssValue = new StringBuilder();
        private boolean hasAttribbute = false;
        private boolean verbatim = false;
        private List<String> conditions = new ArrayList<String>();
        private PrintStream outputStream;

        public Handler() {
            this.outputStream = System.out;
        }

        public Handler(OutputStream outputStream) {
            this.outputStream = new PrintStream(outputStream);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String value;
            String skin;
            String name;
            String value2;
            if (TEMPLATE.equals(localName)) {
                this.ecssContent = new StringBuilder();
            }
            if (IMPORT.equals(localName)) {
                String src = atts.getValue("src");
                this.ecssContent.append("@import url(\"#{resource['");
                this.ecssContent.append(src);
                this.ecssContent.append("']}\");\r\n");
            }
            if (VERBATIM.equals(localName)) {
                this.verbatim = true;
                String skin2 = atts.getValue("skin");
                if (null != skin2) {
                    this.ecssContent.append(" " + this.cssValue("#{a4jSkin." + skin2 + "}") + " ");
                }
            }
            if (SELECTOR.equals(localName) && null != (value2 = atts.getValue("name"))) {
                this.ecssContent.append(value2);
                this.ecssContent.append("{\r\n");
            }
            if (STYLE.equals(localName)) {
                name = atts.getValue("name");
                skin = atts.getValue("skin");
                value = atts.getValue("value");
                String defaultAttr = atts.getValue("default");
                if (null != name) {
                    this.ecssContent.append("\t");
                    this.ecssContent.append(name);
                    this.ecssContent.append(":");
                    if (null != defaultAttr) {
                        if (skin != null) {
                            this.conditions.add("#{not empty a4jSkin." + skin + "}");
                            this.ecssContent.append(this.cssValue("#{a4jSkin." + skin + "}", defaultAttr));
                            this.conditions.remove(this.conditions.size() - 1);
                        } else {
                            this.ecssContent.append(this.cssValue(defaultAttr, null));
                        }
                    } else if (skin != null) {
                        this.ecssContent.append(this.cssValue("#{a4jSkin." + skin + "}", null));
                    } else if (value != null) {
                        this.ecssContent.append(this.cssValue(value, null));
                    }
                }
            }
            if (RESOURCE.equals(localName)) {
                value2 = atts.getValue("f:key");
                if (null != value2) {
                    this.currentCssValue.append("url(#{resource['");
                    this.currentCssValue.append(value2);
                }
                if ((skin = atts.getValue("f:skin")) != null) {
                    this.currentCssValue.append("url(#{resource[a4jSkin.");
                    this.currentCssValue.append(skin);
                }
            }
            if (ATTRIBUTE.equals(localName)) {
                if (!this.hasAttribbute) {
                    this.currentCssValue.append("?");
                    this.hasAttribbute = true;
                }
                name = atts.getValue("name");
                skin = atts.getValue("skin");
                value = atts.getValue("value");
                if (null != name) {
                    if (skin != null) {
                        this.currentCssValue.append(name);
                        this.currentCssValue.append("=");
                        this.currentCssValue.append("Skin.");
                        this.currentCssValue.append(skin);
                        this.currentCssValue.append("&");
                    } else if (value != null) {
                        this.currentCssValue.append(name);
                        this.currentCssValue.append("=");
                        try {
                            this.currentCssValue.append(URLEncoder.encode(value, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        this.currentCssValue.append("&");
                    }
                }
            }
            if (IF.equals(localName)) {
                String condition = atts.getValue("when");
                if (condition == null) {
                    condition = "#{not empty a4jSkin." + atts.getValue("skin") + "}";
                }
                this.conditions.add(condition);
            }
        }

        private String cssValue(String value) {
            return this.cssValue(value, null);
        }

        private String cssValue(String value, String defaultValue) {
            String cssValue = this._cssValue(value, defaultValue);
            if (cssValue != null && cssValue.contains("#{")) {
                cssValue = cssValue.contains("'") ? "\"" + cssValue + "\"" : "'" + cssValue + "'";
            }
            return cssValue;
        }

        private String _cssValue(String value, String defaultValue) {
            if (defaultValue == null || defaultValue.trim().length() == 0) {
                defaultValue = "''";
            }
            if (this.conditions.size() == 0) {
                return value;
            }
            if (this.isEl(defaultValue)) {
                defaultValue = defaultValue.substring(2, defaultValue.length() - 2);
            } else if (!defaultValue.contains("'")) {
                defaultValue = "'" + defaultValue + "'";
            }
            if (this.isEl(value)) {
                int start = value.indexOf("#{");
                int end = value.indexOf("}", start);
                if (start > 0) {
                    return this._cssValue(value.substring(0, start), defaultValue) + this._cssValue(value.substring(start, value.length()), defaultValue);
                }
                if (end < value.length() - 1) {
                    return this._cssValue(value.substring(0, end + 1), defaultValue) + this._cssValue(value.substring(end + 1, value.length()), defaultValue);
                }
                String conditionsString = this.conditionsToString();
                return "#{" + conditionsString + " ? " + value.substring("#{".length(), value.length() - 1) + " : " + defaultValue + "}";
            }
            String conditionsString = this.conditionsToString();
            return "#{" + conditionsString + " ? '" + value + "' : " + defaultValue + "}";
        }

        private String conditionsToString() {
            if (this.conditions.size() == 1) {
                return this.convertCondition(this.conditions.get(0));
            }
            StringBuilder builder = new StringBuilder();
            String sep = "";
            for (String condition : this.conditions) {
                builder.append(sep + "(" + this.convertCondition(condition) + ")");
                sep = " and ";
            }
            return builder.toString();
        }

        private String convertCondition(String condition) {
            if (this.isEl(condition)) {
                return this.removeElDelimiters(condition);
            }
            return this.toEl(condition);
        }

        private boolean isEl(String value) {
            return value.contains("#{");
        }

        private String toEl(String value) {
            return "'" + value + "'";
        }

        private String removeElDelimiters(String value) {
            String current = value.trim();
            if (current.startsWith("#{") && (current = current.substring(2)).endsWith("}")) {
                current = current.substring(0, current.length() - 1);
            }
            return current;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.verbatim) {
                String strValue = new String(ch, start, length);
                this.ecssContent.append(strValue);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (TEMPLATE.equals(localName)) {
                this.outputStream.println(this.ecssContent.toString().trim());
            }
            if (VERBATIM.equals(localName)) {
                this.verbatim = false;
            }
            if (SELECTOR.equals(localName)) {
                this.ecssContent.append("}\r\n");
            }
            if (STYLE.equals(localName)) {
                this.ecssContent.append(";\r\n");
            }
            if (RESOURCE.equals(localName)) {
                if (this.hasAttribbute) {
                    this.currentCssValue.setLength(this.currentCssValue.length() - 1);
                }
                if (this.currentCssValue.indexOf("'") != -1) {
                    this.currentCssValue.append("'");
                }
                this.currentCssValue.append("]})");
                this.ecssContent.append(this.cssValue(this.currentCssValue.toString(), null));
                this.currentCssValue = new StringBuilder();
                this.hasAttribbute = false;
            }
            if (ATTRIBUTE.equals(localName)) {
                // empty if block
            }
            if (IF.equals(localName)) {
                this.conditions.remove(this.conditions.size() - 1);
            }
        }
    }
}

