/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.navigation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.navigation.Pages;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.pathelements.ArchivedVersionsPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.DocumentPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.PathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.TextPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.VersionDocumentPathElement;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.navigation.BreadcrumbActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="breadcrumbActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class BreadcrumbActionsBean
implements BreadcrumbActions,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BREADCRUMB_USER_DOMAINS_PROVIDER = "breadcrumb_user_domains";
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected List<DocumentModel> userDomains = null;
    protected boolean isPathShrinked = false;
    protected static final String BREADCRUMB_PREFIX = "breadcrumb";

    protected int getMinPathSegmentsLen() {
        return 4;
    }

    protected int getMaxPathCharLen() {
        return 80;
    }

    public String getPathEllipsis() {
        return "\u2026";
    }

    public boolean isGoToParentButtonShown() {
        return this.isPathShrinked && !FacesContext.getCurrentInstance().getViewRoot().getViewId().equals("/view_servers.xhtml");
    }

    protected String getViewDomainsOutcome() {
        return "view_domains";
    }

    @Override
    public String navigateToParent() {
        String outcome;
        List<PathElement> documentsFormingPath = this.getBackendPath();
        int nbDocInList = documentsFormingPath.size();
        if (nbDocInList > 0 && documentsFormingPath.get(0).getName().equals(this.getPathEllipsis())) {
            documentsFormingPath.remove(0);
        }
        if ((nbDocInList = documentsFormingPath.size()) == 0) {
            return "view_servers";
        }
        if (nbDocInList > 1) {
            PathElement parentPathElement = documentsFormingPath.get(nbDocInList - 2);
            outcome = this.navigateToPathElement(parentPathElement);
        } else {
            PathElement pathElement = documentsFormingPath.get(0);
            if (pathElement instanceof TextPathElement) {
                DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
                if (currentDocument == null) {
                    return "view_servers";
                }
                return this.navigationContext.navigateToDocument(currentDocument);
            }
            DocumentPathElement currentPathELement = (DocumentPathElement)pathElement;
            DocumentModel doc = currentPathELement.getDocumentModel();
            outcome = this.documentManager.hasPermission(doc.getParentRef(), "Read") ? this.navigationContext.navigateToRef(doc.getParentRef()) : this.navigateToPathElement((PathElement)currentPathELement);
            if (this.navigationContext.getCurrentDocument().getType().equals("CoreRoot")) {
                outcome = this.getViewDomainsOutcome();
            }
        }
        return outcome;
    }

    protected String navigateToPathElement(PathElement pathElement) {
        String elementType = pathElement.getType();
        if (elementType == "DocumentPathElement") {
            DocumentPathElement docPathElement = (DocumentPathElement)pathElement;
            DocumentModel currentDoc = docPathElement.getDocumentModel();
            return this.navigationContext.navigateToDocument(currentDoc);
        }
        if (elementType == "ArchivedVersionsPathElement") {
            ArchivedVersionsPathElement docPathElement = (ArchivedVersionsPathElement)pathElement;
            DocumentModel currentDoc = docPathElement.getDocumentModel();
            return this.navigationContext.navigateToDocument(currentDoc, "TAB_CONTENT_HISTORY");
        }
        if (elementType == "VersionDocumentPathElement") {
            VersionDocumentPathElement element = (VersionDocumentPathElement)pathElement;
            DocumentModel currentDoc = element.getDocumentModel();
            return this.navigationContext.navigateToDocument(currentDoc);
        }
        return null;
    }

    @Override
    @Factory(value="backendPath", scope=ScopeType.EVENT)
    public List<PathElement> getBackendPath() {
        String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        String viewIdLabel = Pages.instance().getPage(viewId).getDescription();
        if (viewIdLabel != null && viewIdLabel.startsWith(BREADCRUMB_PREFIX)) {
            return this.makeBackendPathFromLabel(viewIdLabel.substring(BREADCRUMB_PREFIX.length() + 1));
        }
        return this.shrinkPathIfNeeded(this.navigationContext.getCurrentPathList());
    }

    @Factory(value="isNavigationBreadcrumb", scope=ScopeType.EVENT)
    public boolean isNavigationBreadcrumb() {
        String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        String viewIdLabel = Pages.instance().getPage(viewId).getDescription();
        return viewIdLabel == null || !viewIdLabel.startsWith(BREADCRUMB_PREFIX);
    }

    protected List<PathElement> shrinkPathIfNeeded(List<PathElement> paths) {
        if (paths == null || paths.size() <= this.getMinPathSegmentsLen()) {
            this.isPathShrinked = false;
            return paths;
        }
        StringBuffer sb = new StringBuffer();
        for (PathElement pe : paths) {
            sb.append(pe.getName());
        }
        String completePath = sb.toString();
        if (completePath.length() <= this.getMaxPathCharLen()) {
            this.isPathShrinked = false;
            return paths;
        }
        sb = new StringBuffer();
        ArrayList<PathElement> shrinkedPath = new ArrayList<PathElement>();
        for (int i = paths.size() - 1; i >= 0; --i) {
            PathElement pe = paths.get(i);
            sb.append(pe.getName());
            if (sb.length() >= this.getMaxPathCharLen()) break;
            shrinkedPath.add(0, pe);
        }
        if (shrinkedPath.size() == 0) {
            shrinkedPath.add(0, paths.get(paths.size() - 1));
        }
        this.isPathShrinked = true;
        return shrinkedPath;
    }

    protected List<PathElement> makeBackendPathFromLabel(String label) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
        label = (String)this.resourcesAccessor.getMessages().get(label);
        TextPathElement pathLabel = new TextPathElement(label);
        pathElements.add((PathElement)pathLabel);
        return pathElements;
    }

    public List<DocumentModel> getUserDomains() {
        if (this.userDomains == null) {
            PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put("coreSession", (Serializable)this.documentManager);
            this.userDomains = pageProviderService.getPageProvider(BREADCRUMB_USER_DOMAINS_PROVIDER, null, null, null, properties, new Object[0]).getCurrentPage();
        }
        return this.userDomains;
    }

    public boolean isUserDomain(DocumentModel doc) {
        List<DocumentModel> userDomains = this.getUserDomains();
        for (DocumentModel userDomain : userDomains) {
            if (!doc.getRef().equals(userDomain.getRef())) continue;
            return true;
        }
        return false;
    }

    @Observer(value={"locationSelectionChanged", "documentChildrenChanged", "documentChanged"})
    public void resetUserDomains() {
        this.userDomains = null;
    }
}

