/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderFactory;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderFactoryDescriptor;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentStringBlobHolder;
import org.nuxeo.ecm.core.api.externalblob.ExternalBlobAdapter;
import org.nuxeo.ecm.core.api.externalblob.ExternalBlobAdapterDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class BlobHolderAdapterComponent
extends DefaultComponent
implements BlobHolderAdapterService {
    private static final Log log = LogFactory.getLog(BlobHolderAdapterComponent.class);
    public static final String BLOBHOLDERFACTORY_EP = "BlobHolderFactory";
    public static final String EXTERNALBLOB_ADAPTER_EP = "ExternalBlobAdapter";
    protected final Map<String, BlobHolderFactory> factories = new HashMap<String, BlobHolderFactory>();
    protected Map<String, BlobHolderFactory> factoriesByFacets = new HashMap<String, BlobHolderFactory>();
    protected Map<String, BlobHolderFactory> factoriesByName = new HashMap<String, BlobHolderFactory>();
    protected static final Map<String, ExternalBlobAdapter> externalBlobAdapters = new HashMap<String, ExternalBlobAdapter>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (BLOBHOLDERFACTORY_EP.equals(extensionPoint)) {
            String facet;
            String docType;
            BlobHolderFactoryDescriptor desc = (BlobHolderFactoryDescriptor)contribution;
            String name = desc.getName();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                this.factoriesByName.put(name, desc.getFactory());
            }
            if ((docType = desc.getDocType()) != null) {
                this.factories.put(docType, desc.getFactory());
            }
            if ((facet = desc.getFacet()) != null) {
                this.factoriesByFacets.put(facet, desc.getFactory());
            }
        } else if (EXTERNALBLOB_ADAPTER_EP.equals(extensionPoint)) {
            ExternalBlobAdapterDescriptor desc = (ExternalBlobAdapterDescriptor)contribution;
            ExternalBlobAdapter adapter = desc.getAdapter();
            String prefix = desc.getPrefix();
            if (externalBlobAdapters.containsKey(prefix)) {
                log.info((Object)String.format("Overriding external blob adapter with prefix '%s'", prefix));
                externalBlobAdapters.remove(prefix);
            }
            adapter.setPrefix(desc.getPrefix());
            adapter.setProperties(desc.getProperties());
            externalBlobAdapters.put(desc.getPrefix(), adapter);
            log.info((Object)String.format("Registered external blob adapter with prefix '%s'", prefix));
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public static Set<String> getFactoryNames() {
        return ((BlobHolderAdapterComponent)Framework.getService(BlobHolderAdapterService.class)).factories.keySet();
    }

    @Override
    public ExternalBlobAdapter getExternalBlobAdapterForPrefix(String prefix) {
        return externalBlobAdapters.get(prefix);
    }

    @Override
    public ExternalBlobAdapter getExternalBlobAdapterForUri(String uri) {
        if (uri != null && uri.contains(":")) {
            String prefix = uri.substring(0, uri.indexOf(":"));
            return this.getExternalBlobAdapterForPrefix(prefix);
        }
        return null;
    }

    @Override
    public Blob getExternalBlobForUri(String uri) throws PropertyException, IOException {
        ExternalBlobAdapter adapter = this.getExternalBlobAdapterForUri(uri);
        if (adapter == null) {
            throw new PropertyException(String.format("No external blob adapter found for uri '%s'", uri));
        }
        return adapter.getBlob(uri);
    }

    @Override
    public BlobHolder getBlobHolderAdapter(DocumentModel doc, String factoryName) {
        if (factoryName != null && this.factoriesByName.containsKey(factoryName)) {
            BlobHolderFactory factory = this.factoriesByName.get(factoryName);
            return factory.getBlobHolder(doc);
        }
        if (this.factories.containsKey(doc.getType())) {
            BlobHolderFactory factory = this.factories.get(doc.getType());
            return factory.getBlobHolder(doc);
        }
        for (Map.Entry<String, BlobHolderFactory> entry : this.factoriesByFacets.entrySet()) {
            if (!doc.hasFacet(entry.getKey())) continue;
            return entry.getValue().getBlobHolder(doc);
        }
        if (doc.hasSchema("file")) {
            return new DocumentBlobHolder(doc, "file:content");
        }
        if (doc.hasSchema("note")) {
            String mt = null;
            try {
                String note;
                mt = (String)((Object)doc.getPropertyValue("note:mime_type"));
                if (mt == null && (note = (String)((Object)doc.getPropertyValue("note:note"))) != null && !"".equals(note)) {
                    mt = "text/plain";
                }
            }
            catch (PropertyException propertyException) {
                // empty catch block
            }
            return new DocumentStringBlobHolder(doc, "note:note", mt);
        }
        return null;
    }

    @Override
    public BlobHolder getBlobHolderAdapter(DocumentModel doc) {
        return this.getBlobHolderAdapter(doc, null);
    }
}

