/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;

@Deprecated
public class ScopedMap
extends HashMap<String, Serializable> {
    private static final Log log = LogFactory.getLog(ScopedMap.class);
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PREFIX = ScopeType.DEFAULT.getScopePrefix();
    private static final String REQUEST_PREFIX = ScopeType.REQUEST.getScopePrefix();

    public ScopedMap() {
    }

    public ScopedMap(Map<String, Serializable> map) {
        super(map);
    }

    public Serializable getScopedValue(ScopeType scope, String key) {
        Serializable res = null;
        if (scope != null && key != null) {
            res = (Serializable)super.get(scope.getScopedKey(key));
        }
        return res;
    }

    public Serializable getScopedValue(String key) {
        return this.getScopedValue(ScopeType.DEFAULT, key);
    }

    public Map<String, Serializable> getDefaultScopeValues() {
        return this.getScopeValues(ScopeType.DEFAULT);
    }

    public Map<String, Serializable> getScopeValues(ScopeType scopeType) {
        HashMap<String, Serializable> defMap = new HashMap<String, Serializable>();
        String defaultScopePrefix = scopeType.getScopePrefix();
        int prefixLen = defaultScopePrefix.length();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(defaultScopePrefix)) continue;
            defMap.put(key.substring(prefixLen), (Serializable)entry.getValue());
        }
        return defMap;
    }

    public void putScopedValue(ScopeType scope, String key, Serializable value) {
        if (scope == null || key == null) {
            log.error((Object)String.format("Cannot set scope value using scopeType=%s and key=%s", new Object[]{scope, key}));
        } else {
            super.put(scope.getScopedKey(key), value);
        }
    }

    public void putScopedValue(String key, Serializable value) {
        this.putScopedValue(ScopeType.DEFAULT, key, value);
    }

    public void clearScope(ScopeType scopeType) {
        if (scopeType == null) {
            log.error((Object)"Cannot clear map, specified scope is null");
        } else {
            String prefix = scopeType.getScopePrefix();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                this.remove(key);
            }
        }
    }

    protected Serializable superGet(Object key) {
        return (Serializable)super.get(key);
    }

    protected Serializable superPut(String key, Serializable value) {
        return super.put(key, value);
    }

    @Override
    public Serializable get(Object key) {
        if (key instanceof String) {
            key = this.compatKey((String)key);
        }
        return (Serializable)super.get(key);
    }

    @Override
    public Serializable put(String key, Serializable value) {
        return super.put(this.compatKey(key), value);
    }

    protected String compatKey(String key) {
        if (key.startsWith(DEFAULT_PREFIX)) {
            return key.substring(DEFAULT_PREFIX.length());
        }
        if (key.startsWith(REQUEST_PREFIX)) {
            return key.substring(REQUEST_PREFIX.length());
        }
        return key;
    }
}

