/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JarUtils {
    private JarUtils() {
    }

    public static Manifest getManifest(File file) {
        try {
            if (file.isDirectory()) {
                return JarUtils.getDirectoryManifest(file);
            }
            return JarUtils.getJarManifest(file);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static Manifest getDirectoryManifest(File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest(fis);
            return manifest;
        }
    }

    public static Manifest getJarManifest(File file) throws IOException {
        try (JarFile jar = null;){
            jar = new JarFile(file);
            Manifest manifest = jar.getManifest();
            return manifest;
        }
    }

    public static Manifest getManifest(URL url) {
        try {
            return new JarFile(new File(url.getFile())).getManifest();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Path zipDirectory(final Path source, Path target, final CopyOption ... options) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source argument must be a directory to zip");
        }
        URI uri = JarUtils.toJarURI(target);
        try (final FileSystem zipfs = FileSystems.newFileSystem(uri, Collections.singletonMap("create", "true"));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (source.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return this.visitFile(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = source.relativize(file);
                    Path pathInZipFile = zipfs.getPath(relativePath.toString(), new String[0]);
                    Files.copy(file, pathInZipFile, options);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return target;
    }

    public static URI toJarURI(Path path) {
        try {
            return new URI("jar", path.toUri().toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create Jar URI", e);
        }
    }
}

