/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedContent;
import org.nuxeo.common.xmap.XAnnotatedContext;
import org.nuxeo.common.xmap.XAnnotatedList;
import org.nuxeo.common.xmap.XAnnotatedMap;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XAnnotatedParent;
import org.nuxeo.common.xmap.XFieldAccessor;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMethodAccessor;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XContext;
import org.nuxeo.common.xmap.annotation.XMemberAnnotation;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMap {
    private static DocumentBuilderFactory factory = XMap.initFactory();
    private final Map<String, XAnnotatedObject> roots;
    private final Map<Class<?>, XAnnotatedObject> objects = new Hashtable();
    private final Map<Class<?>, XValueFactory> factories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilderFactory initFactory() {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(XMap.class.getClassLoader());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilderFactory documentBuilderFactory = factory;
            return documentBuilderFactory;
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    public static DocumentBuilderFactory getFactory() {
        return factory;
    }

    public XMap() {
        this.roots = new Hashtable<String, XAnnotatedObject>();
        this.factories = new Hashtable(XValueFactory.defaultFactories);
    }

    public XValueFactory getValueFactory(Class<?> type) {
        return this.factories.get(type);
    }

    public void setValueFactory(Class<?> type, XValueFactory factory) {
        this.factories.put(type, factory);
    }

    public Collection<XAnnotatedObject> getScannedObjects() {
        return this.objects.values();
    }

    public Collection<XAnnotatedObject> getRootObjects() {
        return this.roots.values();
    }

    public XAnnotatedObject register(Class<?> klass) {
        XObject xob;
        XAnnotatedObject xao = this.objects.get(klass);
        if (xao == null && (xob = XMap.checkObjectAnnotation(klass)) != null) {
            xao = new XAnnotatedObject(this, klass, xob);
            this.objects.put(xao.klass, xao);
            this.scan(xao);
            String key = xob.value();
            if (key.length() > 0) {
                this.roots.put(xao.path.path, xao);
            }
        }
        return xao;
    }

    private void scan(XAnnotatedObject xob) {
        this.scanClass(xob, xob.klass);
    }

    private void scanClass(XAnnotatedObject xob, Class<?> aClass) {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = aClass.getDeclaredFields()) {
            Annotation anno = XMap.checkMemberAnnotation(field);
            if (anno == null) continue;
            XAnnotatedMember member = this.createFieldMember(field, anno);
            xob.addMember(member);
        }
        for (Method method : methods = aClass.getDeclaredMethods()) {
            Annotation anno;
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1 || (anno = XMap.checkMemberAnnotation(method)) == null) continue;
            XAnnotatedMember member = this.createMethodMember(method, anno, aClass);
            xob.addMember(member);
        }
        if (aClass.getSuperclass() != null) {
            this.scanClass(xob, aClass.getSuperclass());
        }
    }

    public Object load(URL url) throws IOException {
        return this.load(new Context(), url.openStream());
    }

    public Object load(Context ctx, URL url) throws IOException {
        return this.load(ctx, url.openStream());
    }

    public Object load(InputStream in) throws IOException {
        return this.load(new Context(), in);
    }

    public Object load(Context ctx, InputStream in) throws IOException {
        try {
            DocumentBuilderFactory factory = XMap.getFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Object object = this.load(ctx, document.getDocumentElement());
            return object;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object[] loadAll(URL url) throws IOException {
        return this.loadAll(new Context(), url.openStream());
    }

    public Object[] loadAll(Context ctx, URL url) throws IOException {
        return this.loadAll(ctx, url.openStream());
    }

    public Object[] loadAll(InputStream in) throws IOException {
        return this.loadAll(new Context(), in);
    }

    public Object[] loadAll(Context ctx, InputStream in) throws IOException {
        try {
            DocumentBuilderFactory factory = XMap.getFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Object[] objectArray = this.loadAll(ctx, document.getDocumentElement());
            return objectArray;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object load(Element root) {
        return this.load(new Context(), root);
    }

    public Object load(Context ctx, Element root) {
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            return xob.newInstance(ctx, root);
        }
        for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
            if (p.getNodeType() != 1) continue;
            return this.load((Element)p);
        }
        return null;
    }

    public Object[] loadAll(Context ctx, Element root) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.loadAll(ctx, root, result);
        return result.toArray();
    }

    public Object[] loadAll(Element root) {
        return this.loadAll(new Context(), root);
    }

    public void loadAll(Element root, Collection<Object> result) {
        this.loadAll(new Context(), root, result);
    }

    public void loadAll(Context ctx, Element root, Collection<Object> result) {
        String name = root.getNodeName();
        XAnnotatedObject xob = this.roots.get(name);
        if (xob != null) {
            Object ob = xob.newInstance(ctx, root);
            result.add(ob);
        } else {
            for (Node p = root.getFirstChild(); p != null; p = p.getNextSibling()) {
                if (p.getNodeType() != 1) continue;
                this.loadAll(ctx, (Element)p, result);
            }
        }
    }

    protected static Annotation checkMemberAnnotation(AnnotatedElement ae) {
        Annotation[] annos;
        for (Annotation anno : annos = ae.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(XMemberAnnotation.class)) continue;
            return anno;
        }
        return null;
    }

    protected static XObject checkObjectAnnotation(AnnotatedElement ae) {
        return ae.getAnnotation(XObject.class);
    }

    private XAnnotatedMember createMember(Annotation annotation, XAccessor setter) {
        XAnnotatedMember member = null;
        int type = annotation.annotationType().getAnnotation(XMemberAnnotation.class).value();
        if (type == 1) {
            member = new XAnnotatedMember(this, setter, (XNode)annotation);
        } else if (type == 2) {
            member = new XAnnotatedList(this, setter, (XNodeList)annotation);
        } else if (type == 3) {
            member = new XAnnotatedMap(this, setter, (XNodeMap)annotation);
        } else if (type == 4) {
            member = new XAnnotatedParent(this, setter);
        } else if (type == 5) {
            member = new XAnnotatedContent(this, setter, (XContent)annotation);
        } else if (type == 6) {
            member = new XAnnotatedContext(this, setter, (XContext)annotation);
        }
        return member;
    }

    public final XAnnotatedMember createFieldMember(Field field, Annotation annotation) {
        XFieldAccessor setter = new XFieldAccessor(field);
        return this.createMember(annotation, setter);
    }

    public final XAnnotatedMember createMethodMember(Method method, Annotation annotation, Class<?> klass) {
        XMethodAccessor setter = new XMethodAccessor(method, klass);
        return this.createMember(annotation, setter);
    }

    public String toXML(Object object) throws IOException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory dbfac = XMap.getFactory();
        try {
            docBuilder = dbfac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("root");
        doc.appendChild(root);
        this.toXML(object, root);
        return DOMSerializer.toString(root);
    }

    public void toXML(Object object, OutputStream os) throws IOException {
        String xml = this.toXML(object);
        os.write(xml.getBytes());
    }

    public void toXML(Object object, File file) throws IOException {
        String xml = this.toXML(object);
        FileUtils.writeStringToFile((File)file, (String)xml);
    }

    public void toXML(Object object, Element root) {
        XAnnotatedObject xao = this.objects.get(object.getClass());
        if (xao == null) {
            throw new IllegalArgumentException(object.getClass().getCanonicalName() + " is NOT registred in xmap");
        }
        XMLBuilder.saveToXML(object, root, xao);
    }
}

