/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.io.Serializable;
import java.util.Arrays;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;

public class OperationDocumentation
implements Comparable<OperationDocumentation>,
Serializable {
    private static final long serialVersionUID = 1L;
    public String id;
    public String[] aliases;
    public String[] signature;
    public String category;
    public String label;
    public String requires;
    public String since;
    public String deprecatedSince;
    public boolean addToStudio;
    public String implementationClass;
    public String description;
    public Param[] params;
    public WidgetDefinition[] widgetDefinitions;
    public OperationChainContribution.Operation[] operations;
    public String url;

    public static OperationDocumentation copyForAlias(OperationDocumentation od, String alias) {
        OperationDocumentation documentation = new OperationDocumentation(alias);
        documentation.signature = od.signature;
        documentation.category = od.category;
        documentation.label = od.label;
        documentation.requires = od.requires;
        documentation.since = od.since;
        documentation.deprecatedSince = od.deprecatedSince;
        documentation.addToStudio = od.addToStudio;
        documentation.implementationClass = od.implementationClass;
        documentation.description = od.description;
        documentation.params = od.params;
        documentation.widgetDefinitions = od.widgetDefinitions;
        return documentation;
    }

    public OperationDocumentation(String id) {
        this.id = id;
        this.url = id;
    }

    @Override
    public int compareTo(OperationDocumentation o) {
        String s1 = this.label == null ? this.id : this.label;
        String s2 = o.label == null ? o.id : o.label;
        return s1.compareTo(s2);
    }

    public String getDescription() {
        return this.description;
    }

    public String getSince() {
        return this.since;
    }

    public String getDeprecatedSince() {
        return this.deprecatedSince;
    }

    public boolean isAddToStudio() {
        return this.addToStudio;
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public boolean isChain() {
        return this.id != null && this.id.startsWith("Chain.") || "Chain".equals(this.category);
    }

    public String[] getSignature() {
        return this.signature;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRequires() {
        return this.requires;
    }

    public Param[] getParams() {
        return this.params;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public OperationChainContribution.Operation[] getOperations() {
        return this.operations;
    }

    public String toString() {
        return this.category + " > " + this.label + " [" + this.id + ": " + Arrays.asList(this.signature) + "] (" + this.params + ")\n" + this.description;
    }

    @XObject(value="param")
    public static class Param
    implements Serializable,
    Comparable<Param> {
        private static final long serialVersionUID = 1L;
        @XNode(value="@name")
        public String name;
        @XNode(value="@description")
        public String description;
        @XNode(value="@type")
        public String type;
        public String widget;
        @XNodeList(value="value", type=String[].class, componentType=String.class)
        public String[] values;
        @XNode(value="@order")
        public int order;
        @XNode(value="@required")
        public boolean required;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getWidget() {
            return this.widget;
        }

        public String[] getValues() {
            return this.values;
        }

        public boolean isRequired() {
            return this.required;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.name + " [" + this.type + "] " + (this.required ? "required" : "optional");
        }

        @Override
        public int compareTo(Param o) {
            if (this.order != 0 && o.order != 0) {
                if (this.order < o.order) {
                    return -1;
                }
                if (this.order > o.order) {
                    return 1;
                }
            }
            if (this.required && !o.required) {
                return -1;
            }
            if (o.required && !this.required) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

