/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.work.BlobListZipWork;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.impl.blob.AsyncBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Blob.BulkDownload", category="Files", label="Bulk Downlaod", description="Prepare a Zip of a list of documents which is build asynchrously. Produced Zip will be available in the TransientStore with the key returned by the JSON.")
public class BulkDownload {
    private static final Log log = LogFactory.getLog(BulkDownload.class);
    public static final String ID = "Blob.BulkDownload";
    public static final String WORKERID_KEY = "workerid";
    @Context
    protected CoreSession session;
    @Context
    BlobHolderAdapterService blobHolderAdapterService;
    @Param(name="filename", required=false)
    protected String fileName;

    protected String buildTransientStoreKey(DocumentModelList docs) {
        StringBuffer sb = new StringBuffer();
        for (DocumentModel doc : docs) {
            sb.append(doc.getId());
            sb.append("::");
            Calendar modif = (Calendar)doc.getPropertyValue("dc:modified");
            if (modif == null) continue;
            long millis = modif.getTimeInMillis();
            millis -= millis % 1000L;
            sb.append(millis);
            sb.append("::");
        }
        sb.append(this.session.getPrincipal().getName());
        return DigestUtils.md5Hex((String)sb.toString());
    }

    @OperationMethod
    public Blob run(DocumentModelList docs) throws IOException {
        String key = this.buildTransientStoreKey(docs);
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("download");
        if (ts == null) {
            throw new NuxeoException("Unable to find download Transient Store");
        }
        List<AsyncBlob> blobs = null;
        if (!ts.exists(key)) {
            log.trace((Object)"No async download already initialized");
            BlobListZipWork work = new BlobListZipWork(key, this.session.getPrincipal().getName(), this.fileName, docs.stream().map(DocumentModel::getId).collect(Collectors.toList()), "download");
            ts.setCompleted(key, false);
            ts.putParameter(key, WORKERID_KEY, (Serializable)((Object)work.getId()));
            blobs = Collections.singletonList(new AsyncBlob(key));
            ts.putBlobs(key, blobs);
            ((WorkManager)Framework.getService(WorkManager.class)).schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED);
            return (Blob)blobs.get(0);
        }
        log.trace((Object)"Async download already initialized");
        blobs = ts.getBlobs(key);
        if (ts.isCompleted(key)) {
            if (blobs != null && blobs.size() == 1) {
                Blob blob = (Blob)blobs.get(0);
                ts.release(key);
                return blob;
            }
            ts.release(key);
            throw new NuxeoException("Cannot retrieve blob");
        }
        BlobListZipWork work = new BlobListZipWork(key, this.session.getPrincipal().getName(), this.fileName, docs.stream().map(DocumentModel::getId).collect(Collectors.toList()), "download");
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        wm.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED);
        return new AsyncBlob(key);
    }
}

