/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.ListType;

@Operation(id="Document.AddItemToListProperty", category="Document", label="Adds an Entry Into a Multivalued Complex Property", description="This operation can add new entries to a multivalued complex property. The xpath parameter is the property that should be updated (e.g.: contract:customers). The value parameter is a String containing the JSON-formatted list of entries to add. E.g.: assuming a Contract document type holding customers, each having a firstName and lastName property: [{\"lastName\":\"Norris\", \"firstName\": \"Chuck\"}, {\"lastName\":\"Lee\", \"firstName\": \"Bruce\"}] . Activating the save parameter forces the changes to be written in database immediately (at the cost of performance loss), otherwise changes made to the document will be written in bulk when the chain succeeds.", aliases={"Document.AddItemToListProperty"})
public class AddItemToListProperty {
    public static final String ID = "Document.AddItemToListProperty";
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService service;
    @Context
    protected OperationContext ctx;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="complexJsonProperties")
    protected String complexJsonProperties;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws OperationException, IOException {
        Property complexProperty = doc.getProperty(this.xpath);
        ListType listType = (ListType)complexProperty.getField().getType();
        if (!listType.getFieldType().isComplexType()) {
            throw new OperationException("Property type " + listType.getFieldType().getClass().getName() + " is not supported by this operation");
        }
        List<Object> newVals = ComplexTypeJSONDecoder.decodeList(listType, this.complexJsonProperties);
        for (Object newVal : newVals) {
            complexProperty.addValue(newVal);
        }
        doc = this.session.saveDocument(doc);
        if (this.save) {
            this.session.save();
        }
        return doc;
    }
}

