/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.types.ListType;

@Operation(id="Document.RemoveItemFromListProperty", category="Document", label="Removes an Entry From a Multivalued Complex Property", description="This operation removes an entry from a multivalued complex property, specified using a xpath (e.g.: contract:customers). A specific entry can be removed using its index number. If the index parameter is left empty, all entries in the property are removed. Activating the save parameter forces the changes to be written in database immediately (at the cost of performance loss), otherwise changes made to the document will be written in bulk when the chain succeeds.", aliases={"Document.RemoveItemFromListProperty"})
public class RemoveItemFromListProperty {
    public static final String ID = "Document.RemoveItemFromListProperty";
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService service;
    @Context
    protected OperationContext ctx;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="index", required=false)
    protected Integer index;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws OperationException, IOException {
        if (this.index != null) {
            Property complexProperty = doc.getProperty(this.xpath);
            ListType listType = (ListType)complexProperty.getField().getType();
            if (!listType.getFieldType().isComplexType() && !listType.isListType()) {
                throw new OperationException("Property type is not supported by this operation");
            }
            ListProperty listProperty = (ListProperty)complexProperty;
            List propertiesValues = (List)((Object)listProperty.getValue());
            propertiesValues.remove(this.index);
            listProperty.clear();
            listProperty.setValue((Object)propertiesValues);
        } else {
            Property complexProperty = doc.getProperty(this.xpath);
            ListType listType = (ListType)complexProperty.getField().getType();
            if (!listType.getFieldType().isComplexType() && !listType.isListType()) {
                throw new OperationException("Property type is not supported by this operation");
            }
            ListProperty listProperty = (ListProperty)complexProperty;
            listProperty.clear();
        }
        doc = this.session.saveDocument(doc);
        if (this.save) {
            this.session.save();
        }
        return doc;
    }
}

