/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deprecated
@Operation(id="Context.RunDocumentOperationInNewTx", category="Execution Flow", label="Run Document Chain in new Tx", description="Run an operation chain in a separate tx. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", deprecatedSince="6.0")
public class RunInNewTransaction {
    public static final String ID = "Context.RunDocumentOperationInNewTx";
    private static final Log log = LogFactory.getLog(RunInNewTransaction.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;
    @Param(name="rollbackGlobalOnError", required=false, values={"false"})
    protected boolean rollbackGlobalOnError = false;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters = new Properties();
    @Param(name="timeout", required=false)
    protected Integer timeout = 60;

    @OperationMethod
    public void run() throws OperationException {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return;
        }
        try {
            TransactionHelper.runInNewTransaction(() -> {
                try (OperationContext subctx = this.ctx.getSubContext(this.isolate);){
                    try {
                        this.service.run(subctx, this.chainId, this.chainParameters);
                    }
                    catch (OperationException e) {
                        if (this.rollbackGlobalOnError) {
                            throw new NuxeoException((Throwable)e);
                        }
                        log.error((Object)("Error while executing operation " + this.chainId), (Throwable)e);
                    }
                }
                catch (OperationException e) {
                    throw new NuxeoException((Throwable)e);
                }
            });
        }
        catch (NuxeoException e) {
            if (e.getCause() instanceof OperationException) {
                throw (OperationException)e.getCause();
            }
            throw e;
        }
    }
}

