/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="RunOperationOnList", category="Execution Flow", label="Run For Each", description="Run an operation for each element from the list defined by the 'list' parameter. The 'list' parameter is pointing to a context variable that represents the list which will be iterated. The 'item' parameter represents the name of the context variable which will point to the current element in the list at each iteration. You can use the 'isolate' parameter to specify whether or not the evalution context is the same as the parent context or a copy of it. If the 'isolate' parameter is 'true' then a copy of the current context is used and so that modifications in this context will not affect the parent context. Any input is accepted. The input is returned back as output when operation terminates. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", aliases={"Context.RunOperationOnList"})
public class RunOperationOnList {
    public static final String ID = "RunOperationOnList";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String chainId;
    @Param(name="list")
    protected String listName;
    @Param(name="item", required=false, values={"item"})
    protected String itemName = "item";
    @Param(name="isolate", required=false, values={"true"})
    protected boolean isolate = true;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters = new Properties();
    @Param(name="newTx", required=false, values={"false"}, description="Define if the chain in parameter should be executed in new transaction.")
    protected boolean newTx = false;
    @Param(name="timeout", required=false, description="Define transaction timeout (default to 60 sec).")
    protected Integer timeout = 60;
    @Param(name="rollbackGlobalOnError", required=false, values={"true"}, description="Define if transaction should rollback or not (default to true)")
    protected boolean rollbackGlobalOnError = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws OperationException {
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        try (OperationContext subctx = this.ctx.getSubContext(this.isolate, this.ctx.getInput());){
            Collection<Object> list = null;
            Object listObject = this.ctx.get(this.listName);
            if (listObject != null) {
                if (listObject instanceof Object[]) {
                    list = Arrays.asList((Object[])listObject);
                } else if (listObject instanceof Collection) {
                    list = (Collection)listObject;
                } else {
                    throw new UnsupportedOperationException(listObject.getClass() + " is not a Collection");
                }
                for (Object value : list) {
                    subctx.push(this.itemName, value);
                    try {
                        if (this.newTx) {
                            this.service.runInNewTx(subctx, this.chainId, this.chainParameters, this.timeout, this.rollbackGlobalOnError);
                            continue;
                        }
                        this.service.run(subctx, this.chainId, this.chainParameters);
                    }
                    finally {
                        subctx.pop(this.itemName);
                    }
                }
            }
            if (!this.isolate) {
                for (String varName : vars.keySet()) {
                    if (!this.ctx.getVars().containsKey(varName)) {
                        this.ctx.put(varName, vars.get(varName));
                        continue;
                    }
                    Object value = vars.get(varName);
                    if (this.session != null && value != null && value instanceof DocumentModel) {
                        this.ctx.getVars().put(varName, this.session.getDocument(((DocumentModel)value).getRef()));
                        continue;
                    }
                    this.ctx.getVars().put(varName, value);
                }
            }
        }
    }
}

