/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.VariableMapper;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.nuxeo.ecm.platform.ui.web.binding.EvaluationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class MetaMethodExpression
extends MethodExpression
implements Serializable {
    private static final long serialVersionUID = -2721042412903607760L;
    private MethodExpression originalMethodExpression;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;

    public MetaMethodExpression(MethodExpression originalMethodExpression) {
        this.originalMethodExpression = originalMethodExpression;
    }

    public MetaMethodExpression(MethodExpression originalMethodExpression, FunctionMapper fnMapper, VariableMapper varMapper) {
        this.originalMethodExpression = originalMethodExpression;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaMethodExpression)) {
            return false;
        }
        MetaMethodExpression other = (MetaMethodExpression)obj;
        return this.originalMethodExpression.equals((Object)other.originalMethodExpression);
    }

    public int hashCode() {
        return this.originalMethodExpression.hashCode();
    }

    public String getExpressionString() {
        return this.originalMethodExpression.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.originalMethodExpression.isLiteralText();
    }

    public MethodInfo getMethodInfo(ELContext context) {
        return null;
    }

    private ELContext getLocalContext(ELContext context) {
        if (this.fnMapper == null && this.varMapper == null) {
            return context;
        }
        return new EvaluationContext(context, this.fnMapper, this.varMapper);
    }

    public Object invoke(ELContext context, Object[] params) {
        ELContext nxcontext = this.getLocalContext(context);
        Object res = null;
        if (this.originalMethodExpression != null && (res = this.originalMethodExpression.invoke(nxcontext, params)) instanceof String) {
            String expression = (String)res;
            if (ComponentTagUtils.isValueReference(expression)) {
                FacesContext faces = FacesContext.getCurrentInstance();
                Application app = faces.getApplication();
                ExpressionFactory factory = app.getExpressionFactory();
                MethodExpression newMeth = factory.createMethodExpression(nxcontext, expression, Object.class, new Class[0]);
                try {
                    res = newMeth.invoke(nxcontext, null);
                }
                catch (ELException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new ELException((Throwable)e);
                }
            } else {
                res = expression;
            }
        }
        return res;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.originalMethodExpression = (MethodExpression)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.originalMethodExpression);
    }
}

