/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.platform.audit.api.OrderByExprs;

public class AuditQueryBuilder {
    protected MultiExpression filter = new MultiExpression(Operator.AND, new ArrayList());
    protected OrderByList orders = new OrderByList(null);
    protected long offset = 0L;
    protected long limit = 0L;

    public AuditQueryBuilder() {
        this.orders.clear();
    }

    public Predicate predicate() {
        return this.filter;
    }

    public AuditQueryBuilder addAndPredicate(Predicate predicate) {
        this.filter.values.add(predicate);
        return this;
    }

    public AuditQueryBuilder predicates(Predicate filter, Predicate ... filters) {
        return this.predicates(Stream.concat(Stream.of(filter), Stream.of(filters)).collect(Collectors.toList()));
    }

    public AuditQueryBuilder predicates(List<Predicate> filters) {
        this.filter = new MultiExpression(Operator.AND, filters);
        return this;
    }

    public OrderByList orders() {
        return this.orders;
    }

    public AuditQueryBuilder defaultOrder() {
        return this.orders(OrderByExprs.desc("eventDate"), new OrderByExpr[0]);
    }

    public AuditQueryBuilder order(OrderByExpr order) {
        this.orders.add((Object)order);
        return this;
    }

    public AuditQueryBuilder orders(OrderByExpr order, OrderByExpr ... orders) {
        return this.orders(Stream.concat(Stream.of(order), Stream.of(orders)).collect(Collectors.toList()));
    }

    public AuditQueryBuilder orders(List<OrderByExpr> orders) {
        this.orders.clear();
        this.orders.addAll(orders);
        return this;
    }

    public long offset() {
        return this.offset;
    }

    public AuditQueryBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public long limit() {
        return this.limit;
    }

    public AuditQueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

