/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Predicates;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;

public interface AuditReader {
    default public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
        return this.queryLogs(new AuditQueryBuilder().predicates(Predicates.eq("docUUID", uuid), Predicates.eq("repositoryId", repositoryId)).defaultOrder());
    }

    @Deprecated
    default public List<LogEntry> getLogEntriesFor(String uuid) {
        return this.queryLogs(new AuditQueryBuilder().predicates(Predicates.eq("docUUID", uuid), new Predicate[0]).defaultOrder());
    }

    @Deprecated
    public List<LogEntry> getLogEntriesFor(String var1, Map<String, FilterMapEntry> var2, boolean var3);

    public LogEntry getLogEntryByID(long var1);

    public List<LogEntry> queryLogs(AuditQueryBuilder var1);

    default public List<LogEntry> queryLogs(String[] eventIds, String dateRange) {
        return this.queryLogsByPage(eventIds, (String)null, (String[])null, null, 0, 10000);
    }

    default public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String category, String path, int pageNb, int pageSize) {
        return this.queryLogsByPage(eventIds, dateRange, new String[]{category}, path, pageNb, pageSize);
    }

    default public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) {
        Date limit = null;
        if (dateRange != null) {
            try {
                limit = DateRangeParser.parseDateRangeQuery(new Date(), dateRange);
            }
            catch (AuditQueryException aqe) {
                aqe.addInfo("Wrong date range query. Query was " + dateRange);
                throw aqe;
            }
        }
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    default public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String category, String path, int pageNb, int pageSize) {
        return this.queryLogsByPage(eventIds, limit, new String[]{category}, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(String[] var1, Date var2, String[] var3, String var4, int var5, int var6);

    default public List<LogEntry> nativeQueryLogs(String whereClause, int pageNb, int pageSize) {
        return this.nativeQuery(whereClause, pageNb, pageSize).stream().filter(LogEntry.class::isInstance).map(LogEntry.class::cast).collect(Collectors.toCollection(LinkedList::new));
    }

    default public List<?> nativeQuery(String query, int pageNb, int pageSize) {
        return this.nativeQuery(query, Collections.emptyMap(), pageNb, pageSize);
    }

    public List<?> nativeQuery(String var1, Map<String, Object> var2, int var3, int var4);

    public long getLatestLogId(String var1, String ... var2);

    public List<LogEntry> getLogEntriesAfter(long var1, int var3, String var4, String ... var5);
}

