/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;

public final class BooleanType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    public static final String ID = "boolean";
    public static final BooleanType INSTANCE = new BooleanType();

    private BooleanType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Boolean;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.valueOf((String)value);
    }

    @Override
    public Object decode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        return Boolean.valueOf(str);
    }

    @Override
    public String encode(Object value) {
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        return value != null ? (String)value : "";
    }

    @Override
    public Object newInstance() {
        return Boolean.FALSE;
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    public List<Class<? extends Constraint>> getRelevantConstraints() {
        ArrayList<Class<? extends Constraint>> classes = new ArrayList<Class<? extends Constraint>>();
        classes.add(NotNullConstraint.class);
        return classes;
    }

    @Override
    public boolean support(Class<? extends Constraint> constraint) {
        return NotNullConstraint.class.equals(constraint);
    }
}

