/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Meta;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RtfInfoElement
extends RtfElement {
    private static final byte[] INFO_AUTHOR = DocWriter.getISOBytes((String)"\\author");
    private static final byte[] INFO_SUBJECT = DocWriter.getISOBytes((String)"\\subject");
    private static final byte[] INFO_KEYWORDS = DocWriter.getISOBytes((String)"\\keywords");
    private static final byte[] INFO_TITLE = DocWriter.getISOBytes((String)"\\title");
    private static final byte[] INFO_PRODUCER = DocWriter.getISOBytes((String)"\\operator");
    private static final byte[] INFO_CREATION_DATE = DocWriter.getISOBytes((String)"\\creationdate");
    private int infoType = -1;
    private String content = "";

    public RtfInfoElement(RtfDocument rtfDocument, Meta meta) {
        super(rtfDocument);
        this.infoType = meta.type();
        this.content = meta.getContent();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        switch (this.infoType) {
            case 4: {
                outputStream.write(INFO_AUTHOR);
                break;
            }
            case 2: {
                outputStream.write(INFO_SUBJECT);
                break;
            }
            case 3: {
                outputStream.write(INFO_KEYWORDS);
                break;
            }
            case 1: {
                outputStream.write(INFO_TITLE);
                break;
            }
            case 5: {
                outputStream.write(INFO_PRODUCER);
                break;
            }
            case 6: {
                outputStream.write(INFO_CREATION_DATE);
                break;
            }
            default: {
                outputStream.write(INFO_AUTHOR);
            }
        }
        outputStream.write(DELIMITER);
        if (this.infoType == 6) {
            outputStream.write(DocWriter.getISOBytes((String)this.convertDate(this.content)));
        } else {
            this.document.filterSpecialChar(outputStream, this.content, false, false);
        }
        outputStream.write(CLOSE_GROUP);
    }

    private String convertDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        try {
            Date date = simpleDateFormat.parse(string);
            simpleDateFormat = new SimpleDateFormat("\\'yr'yyyy\\'mo'MM\\'dy'dd\\'hr'HH\\'min'mm\\'sec'ss");
            return simpleDateFormat.format(date);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return "";
        }
    }
}

