/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.util.Work;

@Interceptor(stateless=true)
public class RollbackInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 5551801508325093417L;

    @Override
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Exception e) {
            if (Work.isRollbackRequired(e, this.getComponent().getType() == ComponentType.JAVA_BEAN)) {
                try {
                    Transaction.instance().setRollbackOnly();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isInterceptorEnabled() {
        return true;
    }
}

