/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Audit.Restore", category="Services", label="Restore log entries", description="Restore log entries from an audit storage implementation to the audit backend.")
public class AuditRestore {
    @Context
    protected AuditBackend auditBackend;
    public static final String ID = "Audit.Restore";
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int DEFAULT_KEEP_ALIVE = 10;
    @Param(name="auditStorage")
    protected String auditStorageId;
    @Param(name="batchSize", required=false)
    protected int batchSize = 100;
    @Param(name="keepAlive", required=false)
    protected int keepAlive = 10;

    @OperationMethod
    public void run() {
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        this.auditBackend.restore(audit.getAuditStorage(this.auditStorageId), this.batchSize, this.keepAlive);
    }
}

