/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.query;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;

@Operation(id="Repository.Query", category="Fetch", label="Query", description="Perform a query on the repository. The document list returned will become the input for the next operation.", since="6.0", addToStudio=true, aliases={"Document.Query"})
public class DocumentPaginatedQuery {
    public static final String ID = "Repository.Query";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pageProviderService;
    @Param(name="query", required=true, description="The query to perform.")
    protected String query;
    @Param(name="language", required=false, description="The query language.", widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="currentPageIndex", required=false, description="Target listing page.")
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false, description="Entries number per page.")
    protected Integer pageSize;
    @Param(name="queryParams", required=false, description="Ordered query parameters.")
    protected StringList strParameters;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected String sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected String sortOrder;
    @Param(name="namedParameters", required=false, description="Named parameters to pass to the page provider to fill in query variables.")
    protected Properties namedParameters;

    @OperationMethod
    public DocumentModelList run() throws OperationException {
        Object[] orderedParameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            orderedParameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < orderedParameters.length; ++idx) {
                String value = (String)orderedParameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    orderedParameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                orderedParameters[idx] = this.session.getRepositoryName();
            }
        }
        Long targetPage = null;
        if (this.currentPageIndex != null) {
            targetPage = this.currentPageIndex.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        ArrayList<SortInfo> sortInfoList = new ArrayList<SortInfo>();
        if (!StringUtils.isBlank((String)this.sortBy)) {
            String[] sorts = this.sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((String)this.sortOrder)) {
                orders = this.sortOrder.split(",");
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfoList.add(new SortInfo(sort, sortAscending));
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        DocumentModel searchDocumentModel = DocumentPaginatedQuery.getSearchDocumentModel(this.session, this.namedParameters);
        CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
        desc.setPattern(this.query);
        PaginableDocumentModelListImpl res = new PaginableDocumentModelListImpl(this.pageProviderService.getPageProvider("", (PageProviderDefinition)desc, searchDocumentModel, sortInfoList, targetPageSize, targetPage, props, orderedParameters), null);
        if (res.hasError()) {
            throw new OperationException(res.getErrorMessage());
        }
        return res;
    }

    public static DocumentModel getSearchDocumentModel(CoreSession session, Properties namedParameters) {
        SimpleDocumentModel searchDocumentModel = new SimpleDocumentModel();
        if (namedParameters != null && !namedParameters.isEmpty()) {
            for (Map.Entry entry : namedParameters.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    DocumentHelper.setProperty((CoreSession)session, (DocumentModel)searchDocumentModel, (String)key, (String)value, (boolean)true);
                }
                catch (IOException | PropertyNotFoundException e) {}
            }
            searchDocumentModel.putContextData("namedParameters", (Serializable)namedParameters);
        }
        return searchDocumentModel;
    }
}

