/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.directory.AbstractDirectoryOperation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="User.Get", category="Users & Groups", label="Get Nuxeo Principal", description="Retrieve Nuxeo principal and export it as a DocumentModel, if login parameter is not set the Operation will return informations about the current user, otherwise Directory Administration rights are required.", aliases={"NuxeoPrincipal.Get"})
public class GetNuxeoPrincipal
extends AbstractDirectoryOperation {
    public static final String ID = "User.Get";
    @Context
    protected UserManager umgr;
    @Param(name="login", required=false)
    protected String login;
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run() {
        if (this.login == null || this.login.isEmpty()) {
            return this.umgr.getUserModel(this.ctx.getPrincipal().getName());
        }
        this.validateCanManageDirectories(this.ctx);
        return this.umgr.getUserModel(this.login);
    }
}

