/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.install.Installer;

@XObject(value="append")
public class AppendOperation {
    @XNode(value="@path")
    protected String path;
    @XNode(value="@target")
    protected String target;
    @XNode(value="@appendNewLine")
    protected boolean appendNewLine = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Installer installer, File bundleDir, File installDir) throws IOException {
        File src = new File(bundleDir, this.path);
        if (src.isFile()) {
            File file;
            File parent;
            String text = FileUtils.readFileToString((File)src);
            if (this.appendNewLine) {
                String crlf = System.getProperty("line.separator");
                text = crlf + text + crlf;
            }
            if (!(parent = (file = new File(installDir, this.target)).getParentFile()).isDirectory()) {
                parent.mkdirs();
            }
            boolean append = file.exists();
            try (FileOutputStream out = new FileOutputStream(file, append);){
                out.write(text.getBytes());
            }
        } else {
            installer.logWarning("Could not find path: " + this.path + " to append");
        }
    }
}

