/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Provider
@Produces(value={"*/*", "text/plain"})
public class DocumentBlobHolderWriter
implements MessageBodyWriter<DocumentBlobHolder> {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentBlobHolder.class.isAssignableFrom(type);
    }

    public long getSize(DocumentBlobHolder blobHolder, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        long n = blobHolder.getBlob().getLength();
        return n < 0L ? -1L : n;
    }

    public void writeTo(DocumentBlobHolder blobHolder, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.commitAndReopenTransaction();
        Blob blob = blobHolder.getBlob();
        if (Framework.isTestModeSet()) {
            this.transferBlob(blob, entityStream);
            return;
        }
        DocumentModel doc = blobHolder.getDocument();
        String xpath = blobHolder.getXpath();
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        downloadService.downloadBlob(this.request, this.response, doc, xpath, blob, blob.getFilename(), "download");
    }

    protected void commitAndReopenTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    protected void transferBlob(Blob blob, OutputStream entityStream) throws IOException {
        if (entityStream instanceof BufferingServletOutputStream) {
            ((BufferingServletOutputStream)entityStream).stopBuffering();
        }
        blob.transferTo(entityStream);
        entityStream.flush();
    }
}

