/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.view;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;

public class TemplateView {
    protected URL url;
    protected WebContext ctx;
    protected Object target;
    protected Map<String, Object> bindings;

    public static URL findTemplate(Object owner, String name) {
        URL url = owner.getClass().getResource(name);
        if (url == null && (url = Framework.getResourceLoader().getResource(name)) == null) {
            throw new WebResourceNotFoundException("View not found: " + name + " for object " + owner);
        }
        return url;
    }

    public TemplateView(Object owner, String name) {
        this(WebEngine.getActiveContext(), owner, name);
    }

    public TemplateView(WebContext ctx, Object owner, String name) {
        this(ctx, owner, TemplateView.findTemplate(owner, name));
    }

    public TemplateView(Object owner, URL url) {
        this(WebEngine.getActiveContext(), owner, url);
    }

    public TemplateView(WebContext ctx, Object owner, URL url) {
        if (ctx == null) {
            throw new NuxeoException("Not in WebEngine context");
        }
        this.ctx = ctx;
        this.target = owner;
        this.url = url;
        this.bindings = new HashMap<String, Object>();
        this.bindings.put("This", this.target);
        this.bindings.put("Context", ctx);
        this.bindings.put("Engine", ctx.getEngine());
        this.bindings.put("basePath", ctx.getBasePath());
        this.bindings.put("contextPath", VirtualHostHelper.getContextPathProperty());
    }

    public WebContext getContext() {
        return this.ctx;
    }

    public TemplateView arg(String key, Object value) {
        this.bindings.put(key, value);
        return this;
    }

    public TemplateView args(Map<String, Object> args) {
        this.bindings.putAll(args);
        return this;
    }

    public void render(Writer writer) {
        try {
            this.ctx.getEngine().getRendering().render(this.url.toExternalForm(), this.bindings, writer);
        }
        catch (RenderingException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            this.render(writer);
        }
        finally {
            try {
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    public String getString() {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return writer.toString();
    }
}

