/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.ThrowingCallable;
import org.jetbrains.annotations.NotNull;

public enum Threads {

    static final Field GROUP = Jvm.getField(Thread.class, (String)"group");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static <R, T extends Throwable> R withThreadGroup(ThreadGroup tg, @NotNull ThrowingCallable<R, T> callable) throws T {
        Thread thread = Thread.currentThread();
        ThreadGroup tg0 = thread.getThreadGroup();
        Threads.setThreadGroup(thread, tg);
        try {
            Object object = callable.call();
            return (R)object;
        }
        finally {
            Threads.setThreadGroup(thread, tg0);
        }
    }

    @ForceInline
    public static void setThreadGroup(Thread thread, ThreadGroup tg) {
        try {
            GROUP.set(thread, tg);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static String threadGroupPrefix() {
        String threadGroupName = Thread.currentThread().getThreadGroup().getName();
        if (!threadGroupName.endsWith("/")) {
            threadGroupName = threadGroupName + "/";
        }
        return threadGroupName;
    }

    static void shutdown(@NotNull ExecutorService service) {
        service.shutdown();
        try {
            service.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            service.shutdownNow();
        }
        try {
            service.awaitTermination(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

