/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.Xml2TextHandler;
import org.xml.sax.SAXException;

public class XML2TextConverter
implements Converter {
    public BlobHolder convert(BlobHolder holder, Map<String, Serializable> parameters) throws ConversionException {
        return new SimpleBlobHolder((Blob)new StringBlob(this.convert(holder.getBlob(), parameters)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String convert(Blob blob, Map<String, Serializable> parameters) {
        if (blob.getLength() == 0L) {
            return "";
        }
        try (InputStream stream = blob.getStream();){
            Xml2TextHandler xml2text = new Xml2TextHandler();
            String string = xml2text.parse(stream);
            return string;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ConversionException("Error during XML2Text conversion", (Throwable)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

