/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManagerImpl;
import org.nuxeo.runtime.api.Framework;

public class UserManagerWithComputedGroups
extends UserManagerImpl {
    private static final long serialVersionUID = 1L;
    protected static ComputedGroupsService cgs;
    protected static Boolean useComputedGroup;
    public static final String VIRTUAL_GROUP_MARKER = "__virtualGroup";

    protected ComputedGroupsService getService() {
        if (cgs == null) {
            cgs = (ComputedGroupsService)Framework.getService(ComputedGroupsService.class);
        }
        return cgs;
    }

    protected boolean activateComputedGroup() {
        if (useComputedGroup == null || Framework.isTestModeSet()) {
            useComputedGroup = this.getService().activateComputedGroups();
        }
        return useComputedGroup;
    }

    @Override
    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, List<String> groups) {
        NuxeoPrincipal principal = super.makePrincipal(userEntry, anonymous, groups);
        if (this.activateComputedGroup() && principal instanceof NuxeoPrincipalImpl) {
            ArrayList<String> origVGroups;
            NuxeoPrincipalImpl nuxPrincipal = (NuxeoPrincipalImpl)principal;
            List<String> vGroups = this.getService().computeGroupsForUser(nuxPrincipal);
            if (vGroups == null) {
                vGroups = new ArrayList<String>();
            }
            if ((origVGroups = nuxPrincipal.getVirtualGroups()) == null) {
                origVGroups = new ArrayList<String>();
            }
            origVGroups.addAll(vGroups);
            nuxPrincipal.setVirtualGroups(origVGroups);
            if (!Framework.isTestModeSet()) {
                nuxPrincipal.updateAllGroups();
            } else {
                List allGroups = nuxPrincipal.getGroups();
                for (String vGroup : vGroups) {
                    if (allGroups.contains(vGroup)) continue;
                    allGroups.add(vGroup);
                }
                nuxPrincipal.setGroups(allGroups);
            }
        }
        return principal;
    }

    @Override
    public NuxeoGroup getGroup(String groupName) {
        NuxeoGroup computed;
        NuxeoGroup grp = super.getGroup(groupName);
        if (this.activateComputedGroup() && (grp == null || this.getService().allowGroupOverride()) && (computed = this.getService().getComputedGroup(groupName, this.groupConfig)) != null) {
            grp = computed;
        }
        return grp;
    }

    @Override
    public NuxeoGroup getGroup(String groupName, DocumentModel context) {
        NuxeoGroup computed;
        NuxeoGroup grp = super.getGroup(groupName, context);
        if (this.activateComputedGroup() && (grp == null || this.getService().allowGroupOverride()) && (computed = this.getService().getComputedGroup(groupName, this.groupConfig)) != null) {
            grp = computed;
        }
        return grp;
    }

    @Override
    public List<String> getGroupIds() {
        List<String> ids = super.getGroupIds();
        if (this.activateComputedGroup()) {
            List<String> vGroups = this.getService().computeGroupIds();
            for (String vGroup : vGroups) {
                if (ids.contains(vGroup)) continue;
                ids.add(vGroup);
            }
        }
        return ids;
    }

    @Override
    public DocumentModel getGroupModel(String groupName) {
        DocumentModel grpDoc = super.getGroupModel(groupName);
        if (this.activateComputedGroup() && grpDoc == null) {
            return this.getComputedGroupAsDocumentModel(groupName);
        }
        return grpDoc;
    }

    @Override
    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        return this.searchGroups(filter, fulltext, null);
    }

    @Override
    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) {
        boolean searchInVirtualGroups = this.activateComputedGroup();
        if (Boolean.FALSE.equals(filter.get(VIRTUAL_GROUP_MARKER))) {
            searchInVirtualGroups = false;
        }
        this.removeVirtualFilters(filter);
        DocumentModelList groups = super.searchGroups(filter, fulltext, context);
        if (searchInVirtualGroups) {
            for (String vGroupName : this.getService().searchComputedGroups(filter, fulltext)) {
                DocumentModel vGroup = this.getComputedGroupAsDocumentModel(vGroupName);
                if (vGroup == null || groups.contains((Object)vGroup)) continue;
                groups.add((Object)vGroup);
            }
        }
        return groups;
    }

    protected DocumentModel getComputedGroupAsDocumentModel(String grpName) {
        NuxeoGroup grp = this.getService().getComputedGroup(grpName, this.groupConfig);
        if (grp == null) {
            return null;
        }
        String schemaName = this.getGroupSchemaName();
        String id = this.getGroupIdField();
        DocumentModel groupDoc = BaseSession.createEntryModel(null, (String)schemaName, (String)grpName, null);
        groupDoc.setProperty(schemaName, this.getGroupMembersField(), (Object)grp.getMemberUsers());
        groupDoc.setProperty(schemaName, id, (Object)grp.getName());
        groupDoc.setProperty(schemaName, this.getGroupIdField(), (Object)grp.getName());
        groupDoc.putContextData("virtual", (Serializable)Boolean.TRUE);
        return groupDoc;
    }

    @Override
    public DocumentModel createGroup(DocumentModel groupModel, DocumentModel context) {
        if (this.activateComputedGroup()) {
            String groupName = (String)groupModel.getProperty(this.groupConfig.schemaName, this.groupConfig.idField);
            NuxeoGroup computed = this.getService().getComputedGroup(groupName, this.groupConfig);
            if (computed != null) {
                throw new NuxeoException("Cannot create a computed group");
            }
        }
        return super.createGroup(groupModel, context);
    }

    @Override
    public void updateGroup(DocumentModel groupModel, DocumentModel context) {
        if (this.activateComputedGroup()) {
            String groupName = (String)groupModel.getProperty(this.groupConfig.schemaName, this.groupConfig.idField);
            NuxeoGroup computed = this.getService().getComputedGroup(groupName, this.groupConfig);
            if (computed != null) {
                throw new NuxeoException("Cannot update a computed group");
            }
        }
        super.updateGroup(groupModel, context);
    }

    @Override
    public void deleteGroup(String groupId, DocumentModel context) {
        NuxeoGroup computed;
        if (this.activateComputedGroup() && (computed = this.getService().getComputedGroup(groupId, this.groupConfig)) != null) {
            throw new NuxeoException("Cannot delete a computed group");
        }
        super.deleteGroup(groupId, context);
    }
}

