/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.io;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentPropertiesJsonReader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.NuxeoGroupImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NuxeoGroupJsonReader
extends EntityJsonReader<NuxeoGroup> {
    @Inject
    private UserManager userManager;

    public NuxeoGroupJsonReader() {
        super("group");
    }

    protected NuxeoGroup readEntity(JsonNode jn) throws IOException {
        GroupConfig groupConfig = this.userManager.getGroupConfig();
        String id = this.getStringField(jn, "id");
        String groupName = this.getStringField(jn, "groupname");
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isNotBlank((CharSequence)groupName) && !id.equals(groupName)) {
            id = groupName;
        }
        DocumentModel groupModel = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            groupModel = this.userManager.getGroupModel(id);
        }
        if (groupModel == null) {
            groupModel = this.userManager.getBareGroupModel();
            groupModel.setProperty(groupConfig.schemaName, groupConfig.idField, (Object)id);
        }
        String beforeReadLabel = (String)groupModel.getProperty(groupConfig.schemaName, groupConfig.labelField);
        this.readProperties(groupModel, groupConfig, jn);
        this.readMemberUsers(groupModel, groupConfig, jn);
        this.readMemberGroups(groupModel, groupConfig, jn);
        this.readParentGroups(groupModel, groupConfig, jn);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            groupModel.setProperty(groupConfig.schemaName, groupConfig.idField, (Object)id);
        }
        if (jn.has("grouplabel")) {
            String compatLabel = this.getStringField(jn, "grouplabel");
            String label = (String)groupModel.getProperty(groupConfig.schemaName, groupConfig.labelField);
            if (!Objects.equals(label, compatLabel) && (beforeReadLabel == null || Objects.equals(beforeReadLabel, label))) {
                groupModel.setProperty(groupConfig.schemaName, groupConfig.labelField, (Object)compatLabel);
            }
        }
        return new NuxeoGroupImpl(groupModel, groupConfig);
    }

    protected void readProperties(DocumentModel groupModel, GroupConfig groupConfig, JsonNode jn) throws IOException {
        List<String> excludedProperties = Arrays.asList(groupConfig.membersField, groupConfig.subGroupsField, groupConfig.parentGroupsField);
        JsonNode propsNode = jn.get("properties");
        if (propsNode != null && !propsNode.isNull() && propsNode.isObject()) {
            ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
            try (Closeable resource = this.ctx.wrap().with(DocumentPropertiesJsonReader.DEFAULT_SCHEMA_NAME, (Object)groupConfig.schemaName).open();){
                List properties = (List)this.readEntity(List.class, genericType, propsNode);
                properties.stream().filter(p -> !excludedProperties.contains(p)).forEach(p -> groupModel.setPropertyValue(p.getName(), p.getValue()));
            }
        }
    }

    protected void readMemberUsers(DocumentModel groupModel, GroupConfig groupConfig, JsonNode jn) {
        if (jn.has("memberUsers")) {
            List<String> users = this.getArrayStringValues(jn.get("memberUsers"));
            groupModel.setProperty(groupConfig.schemaName, groupConfig.membersField, users);
        }
    }

    protected void readMemberGroups(DocumentModel groupModel, GroupConfig groupConfig, JsonNode jn) {
        if (jn.has("memberGroups")) {
            List<String> groups = this.getArrayStringValues(jn.get("memberGroups"));
            groupModel.setProperty(groupConfig.schemaName, groupConfig.subGroupsField, groups);
        }
    }

    protected void readParentGroups(DocumentModel groupModel, GroupConfig groupConfig, JsonNode jn) {
        if (jn.has("parentGroups")) {
            List<String> parents = this.getArrayStringValues(jn.get("parentGroups"));
            groupModel.setProperty(groupConfig.schemaName, groupConfig.parentGroupsField, parents);
        }
    }

    private List<String> getArrayStringValues(JsonNode node) {
        ArrayList<String> values = new ArrayList<String>();
        if (node != null && !node.isNull() && node.isArray()) {
            node.getElements().forEachRemaining(n -> {
                if (n != null && !n.isNull() && n.isTextual()) {
                    values.add(n.getTextValue());
                }
            });
        }
        return values;
    }
}

