/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.AbstractConnectConnector;
import org.nuxeo.connect.connector.CanNotReachConnectServer;
import org.nuxeo.connect.connector.ConnectClientVersionMismatchError;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;
import org.nuxeo.connect.connector.http.ConnectHttpResponse;
import org.nuxeo.connect.connector.http.ProxyHelper;
import org.nuxeo.connect.data.SubscriptionStatus;

public class ConnectHttpConnector
extends AbstractConnectConnector {
    public String overrideUrl = null;
    protected SubscriptionStatus cachedStatus = null;
    protected boolean connectServerNotReachable;
    public static final String CONNECT_HTTP_CACHE_MINUTES_PROPERTY = "org.nuxeo.connect.http.cache.duration";
    public static final String CONNECT_HTTP_TIMEOUT = "org.nuxeo.connect.http.timeout";
    protected int connectHttpTimeout = Integer.parseInt(NuxeoConnectClient.getProperty("org.nuxeo.connect.http.timeout", "10000"));
    protected long lastStatusFetchTime;

    @Override
    protected String getBaseUrl() {
        if (this.overrideUrl != null) {
            return this.overrideUrl;
        }
        return super.getBaseUrl();
    }

    @Override
    protected ConnectServerResponse execServerCall(String url, Map<String, String> headers) throws ConnectServerError {
        return this.execServer(true, url, headers);
    }

    @Override
    protected ConnectServerResponse execServerPost(String url, Map<String, String> headers) throws ConnectServerError {
        return this.execServer(false, url, headers);
    }

    protected ConnectServerResponse execServer(boolean get, String url, Map<String, String> headers) throws ConnectServerError {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        ProxyHelper.configureProxyIfNeeded(httpClientBuilder, url);
        httpClientBuilder.setConnectionTimeToLive((long)this.connectHttpTimeout, TimeUnit.MILLISECONDS);
        HttpGet method = get ? new HttpGet(url) : new HttpPost(url);
        for (String name : headers.keySet()) {
            method.addHeader(name, headers.get(name));
        }
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpClient = httpClientBuilder.build();
            httpResponse = httpClient.execute((HttpUriRequest)method);
            int rc = httpResponse.getStatusLine().getStatusCode();
            switch (rc) {
                case 200: 
                case 204: 
                case 404: {
                    return new ConnectHttpResponse(httpClient, httpResponse);
                }
                case 401: {
                    httpResponse.close();
                    httpClient.close();
                    throw new ConnectSecurityError("Connect server refused authentication (returned 401)");
                }
                case 407: {
                    httpResponse.close();
                    httpClient.close();
                    throw new ConnectSecurityError("Proxy server require authentication (returned 407)");
                }
                case 408: 
                case 504: {
                    httpResponse.close();
                    httpClient.close();
                    throw new ConnectServerError("Timeout " + rc);
                }
            }
            try {
                try {
                    String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                    JSONObject obj = new JSONObject(body);
                    String message = obj.getString("message");
                    String errorClass = obj.getString("errorClass");
                    ConnectServerError error = ConnectSecurityError.class.getSimpleName().equals(errorClass) ? new ConnectSecurityError(message) : (ConnectClientVersionMismatchError.class.getSimpleName().equals(errorClass) ? new ConnectClientVersionMismatchError(message) : new ConnectServerError(message));
                    throw error;
                }
                catch (JSONException e) {
                    log.debug((Object)("Can't parse server error " + rc), (Throwable)e);
                    throw new ConnectServerError("Server returned a code " + rc);
                }
            }
            catch (Throwable throwable) {
                httpResponse.close();
                httpClient.close();
                throw throwable;
            }
        }
        catch (ConnectServerError cse) {
            throw cse;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(httpResponse);
            IOUtils.closeQuietly((Closeable)httpClient);
            throw new ConnectServerError("Error during communication with the Nuxeo Connect Server", e);
        }
    }

    protected int httpCacheDurationInMinutes() {
        String cacheInMinutes = NuxeoConnectClient.getProperty(CONNECT_HTTP_CACHE_MINUTES_PROPERTY, "0");
        try {
            return Integer.parseInt(cacheInMinutes);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected boolean useHttpCache() {
        return this.httpCacheDurationInMinutes() > 0;
    }

    @Override
    public SubscriptionStatus getConnectStatus() throws ConnectServerError {
        if (!this.isConnectServerReachable()) {
            throw new CanNotReachConnectServer("Connect server set as not reachable");
        }
        if (this.useHttpCache() && this.cachedStatus != null && System.currentTimeMillis() - this.lastStatusFetchTime < (long)(this.httpCacheDurationInMinutes() * 60 * 1000)) {
            return this.cachedStatus;
        }
        try {
            SubscriptionStatus status = super.getConnectStatus();
            if (!NuxeoConnectClient.isTestModeSet() && this.useHttpCache()) {
                this.cachedStatus = status;
            }
            this.lastStatusFetchTime = System.currentTimeMillis();
            return status;
        }
        catch (CanNotReachConnectServer e) {
            if (this.cachedStatus != null) {
                return this.cachedStatus;
            }
            throw e;
        }
    }
}

