/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum BackgroundTimeProvider implements TimeProvider
{
    INSTANCE;

    static volatile long delta;
    static int count;

    void run() {
        try {
            for (int i = 0; i < 1000; ++i) {
                delta = SystemTimeProvider.INSTANCE.delta;
                Thread.yield();
            }
            while (true) {
                long delta2 = SystemTimeProvider.INSTANCE.delta;
                delta += (delta2 - delta) / 8L;
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        return this.currentTimeNanos() / 1000L;
    }

    @Override
    public long currentTimeNanos() {
        if (count++ > 20) {
            count = 0;
            return SystemTimeProvider.INSTANCE.currentTimeNanos();
        }
        return System.nanoTime() + delta;
    }

    static {
        count = 0;
        delta = SystemTimeProvider.INSTANCE.delta;
        Thread t = new Thread(INSTANCE::run, "bg-time-provider");
        t.setDaemon(true);
        t.start();
    }
}

