/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ObjectUtils;

public abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final ClassLocal<MethodHandles.Lookup> PRIVATE_LOOKUP = ClassLocal.withInitial(AbstractInvocationHandler::acquireLookup);
    private static final Object[] NO_ARGS = new Object[0];
    private Closeable closeable;
    private Map<Object, Function<Method, MethodHandle>> proxyToLambda;
    private Map<Method, MethodHandle> defaultMethod;

    protected AbstractInvocationHandler(Supplier<Map> mapSupplier) {
        this.proxyToLambda = mapSupplier.get();
        this.defaultMethod = mapSupplier.get();
    }

    private static MethodHandles.Lookup acquireLookup(Class<?> c) {
        try {
            Constructor lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            if (!lookupConstructor.isAccessible()) {
                lookupConstructor.setAccessible(true);
            }
            return (MethodHandles.Lookup)lookupConstructor.newInstance(c, 2);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException lookupConstructor) {
            try {
                Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                field.setAccessible(true);
                return (MethodHandles.Lookup)field.get(null);
            }
            catch (Exception e) {
                return MethodHandles.lookup();
            }
        }
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object o;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (declaringClass == Closeable.class && method.getName().equals("close")) {
            Closeable.closeQuietly((Object)this.closeable);
            return null;
        }
        if (args == null) {
            args = NO_ARGS;
        }
        return (o = this.doInvoke(proxy, method, args)) == null ? ObjectUtils.defaultValue(method.getReturnType()) : o;
    }

    protected abstract Object doInvoke(Object var1, Method var2, Object[] var3) throws InvocationTargetException, IllegalAccessException;

    MethodHandle methodHandleForProxy(Object proxy, Method m) {
        try {
            Class<?> declaringClass = m.getDeclaringClass();
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)PRIVATE_LOOKUP.get(declaringClass);
            return lookup.in(declaringClass).unreflectSpecial(m, declaringClass).bindTo(proxy);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void onClose(Closeable closeable) {
        this.closeable = closeable;
    }
}

