/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.adapter.base;

import java.util.List;
import java.util.Locale;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.diff.content.ContentDiffAdapter;
import org.nuxeo.ecm.diff.content.ContentDiffException;
import org.nuxeo.ecm.diff.content.ContentDiffHelper;
import org.nuxeo.ecm.diff.content.adapter.ContentDiffAdapterManager;
import org.nuxeo.ecm.diff.content.adapter.base.ContentDiffConversionType;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractContentDiffAdapter
implements ContentDiffAdapter {
    protected DocumentModel adaptedDoc;

    @Override
    public String getFileContentDiffURL(DocumentModel otherDoc, ContentDiffConversionType conversionType, String locale) {
        return ContentDiffHelper.getContentDiffURL(this.adaptedDoc, otherDoc, conversionType.name(), locale);
    }

    @Override
    public String getFileContentDiffURL(DocumentModel otherDoc, String xpath, ContentDiffConversionType conversionType, String locale) {
        return ContentDiffHelper.getContentDiffURL(this.adaptedDoc, otherDoc, xpath, conversionType.name(), locale);
    }

    @Override
    public List<Blob> getFileContentDiffBlobs(DocumentModel otherDoc, ContentDiffConversionType conversionType, Locale locale) throws ContentDiffException, ConversionException {
        return this.getContentDiffBlobs(otherDoc, conversionType, locale);
    }

    @Override
    public List<Blob> getFileContentDiffBlobs(DocumentModel otherDoc, String xpath, ContentDiffConversionType conversionType, Locale locale) throws ContentDiffException, ConversionException {
        return this.getContentDiffBlobs(otherDoc, xpath, conversionType, locale);
    }

    protected abstract List<Blob> getContentDiffBlobs(DocumentModel var1, ContentDiffConversionType var2, Locale var3) throws ContentDiffException, ConversionException;

    protected abstract List<Blob> getContentDiffBlobs(DocumentModel var1, String var2, ContentDiffConversionType var3, Locale var4) throws ContentDiffException, ConversionException;

    @Override
    public void setAdaptedDocument(DocumentModel doc) {
        this.adaptedDoc = doc;
    }

    protected final ContentDiffAdapterManager getContentDiffAdapterManager() {
        return (ContentDiffAdapterManager)Framework.getService(ContentDiffAdapterManager.class);
    }
}

