/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;

public class ChronicleRetentionDuration {
    protected static final String SECOND_ROLLING_PERIOD = "s";
    protected static final String MINUTE_ROLLING_PERIOD = "m";
    protected static final String HOUR_ROLLING_PERIOD = "h";
    protected static final String DAY_ROLLING_PERIOD = "d";
    protected final RollCycle rollCycle;
    protected final int retentionCycles;
    protected final String retention;
    public static final ChronicleRetentionDuration DISABLE = new ChronicleRetentionDuration("0d");

    public ChronicleRetentionDuration(String retention) {
        this.retention = retention;
        this.rollCycle = this.decodeRollCycle(retention);
        this.retentionCycles = this.decodeRetentionCycles(retention);
    }

    public String toString() {
        return this.disable() ? "disabled" : this.retention;
    }

    public boolean disable() {
        return this.retentionCycles <= 0;
    }

    public RollCycle getRollCycle() {
        return this.rollCycle;
    }

    public String getRetention() {
        return this.retention;
    }

    public int getRetentionCycles() {
        return this.retentionCycles;
    }

    protected RollCycle decodeRollCycle(String retentionDuration) {
        String rollingPeriod;
        if (retentionDuration == null || retentionDuration.isEmpty()) {
            return RollCycles.DAILY;
        }
        switch (rollingPeriod = retentionDuration.substring(retentionDuration.length() - 1)) {
            case "s": {
                return RollCycles.TEST_SECONDLY;
            }
            case "m": {
                return RollCycles.MINUTELY;
            }
            case "h": {
                return RollCycles.HOURLY;
            }
            case "d": {
                return RollCycles.DAILY;
            }
        }
        String msg = "Unknown rolling period: " + rollingPeriod;
        throw new IllegalArgumentException(msg);
    }

    protected int decodeRetentionCycles(String retentionDuration) {
        if (retentionDuration != null) {
            return Integer.parseInt(retentionDuration.substring(0, retentionDuration.length() - 1));
        }
        return 0;
    }
}

