/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KafkaConfigParser {
    protected String zkServers;
    private Properties producerProperties;
    private Properties consumerProperties;
    private String prefix;

    public KafkaConfigParser(Path path, String configName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(path.toFile());
            NodeList nodes = document.getElementsByTagName("kafkaConfig");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                if (!configName.equals(name)) continue;
                this.parseConfig(node);
                return;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Invalid Kafka config file: " + path, e);
        }
        throw new IllegalArgumentException(String.format("Config: %s not found in file: %s", configName, path));
    }

    protected void parseConfig(Node node) {
        this.prefix = node.getAttributes().getNamedItem("topicPrefix").getNodeValue();
        this.zkServers = node.getAttributes().getNamedItem("zkServers").getNodeValue();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("producer".equals(child.getNodeName())) {
                this.producerProperties = this.decodeProperties(child);
                continue;
            }
            if (!"consumer".equals(child.getNodeName())) continue;
            this.consumerProperties = this.decodeProperties(child);
        }
    }

    protected Properties decodeProperties(Node node) {
        NodeList children = node.getChildNodes();
        Properties ret = new Properties();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"property".equals(child.getNodeName())) continue;
            ret.put(child.getAttributes().getNamedItem("name").getNodeValue(), child.getTextContent());
        }
        return ret;
    }

    public String getZkServers() {
        return this.zkServers;
    }

    public Properties getProducerProperties() {
        return this.producerProperties;
    }

    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

