/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.NodeDetail;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.diff.model.DifferenceType;
import org.nuxeo.ecm.diff.model.DocumentDiff;
import org.nuxeo.ecm.diff.model.PropertyDiff;
import org.nuxeo.ecm.diff.model.PropertyType;
import org.nuxeo.ecm.diff.model.SchemaDiff;
import org.nuxeo.ecm.diff.model.impl.ComplexPropertyDiff;
import org.nuxeo.ecm.diff.model.impl.ContentProperty;
import org.nuxeo.ecm.diff.model.impl.ContentPropertyDiff;
import org.nuxeo.ecm.diff.model.impl.ListPropertyDiff;
import org.nuxeo.ecm.diff.model.impl.PropertyHierarchyNode;
import org.nuxeo.ecm.diff.model.impl.SimplePropertyDiff;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FieldDiffHelper {
    private static final Log LOGGER = LogFactory.getLog(FieldDiffHelper.class);
    public static final String FACET_ELEMENT = "facet";
    public static final String SCHEMA_ELEMENT = "schema";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";

    public static boolean computeFieldDiff(DocumentDiff docDiff, NodeDetail controlNodeDetail, NodeDetail testNodeDetail, int fieldDifferenceCount, Difference difference) {
        Node currentNode = controlNodeDetail.getNode();
        if (currentNode == null) {
            currentNode = testNodeDetail.getNode();
        }
        if (currentNode != null) {
            Node parentNode;
            String field = null;
            String currentNodeName = currentNode.getNodeName();
            ArrayList<PropertyHierarchyNode> propertyHierarchy = new ArrayList<PropertyHierarchyNode>();
            for (parentNode = currentNode.getParentNode(); parentNode != null && !SCHEMA_ELEMENT.equals(currentNodeName) && !"data".equals(parentNode.getNodeName()); parentNode = parentNode.getParentNode()) {
                String currentNodeLocalName;
                String propertyType = FieldDiffHelper.getPropertyType(currentNode);
                String parentPropertyType = FieldDiffHelper.getPropertyType(parentNode);
                if (PropertyType.isListType(parentPropertyType)) {
                    int currentNodePosition = FieldDiffHelper.getNodePosition(currentNode);
                    propertyHierarchy.add(new PropertyHierarchyNode(parentPropertyType, String.valueOf(currentNodePosition)));
                } else if (PropertyType.isComplexType(parentPropertyType) || PropertyType.isContentType(parentPropertyType)) {
                    propertyHierarchy.add(new PropertyHierarchyNode(parentPropertyType, currentNodeName));
                }
                if (SCHEMA_ELEMENT.equals(parentNode.getNodeName()) && !FACET_ELEMENT.equals(currentNodeLocalName = currentNode.getLocalName())) {
                    field = currentNodeLocalName;
                    if (PropertyType.isSimpleType(propertyType) || PropertyType.isListType(propertyType) && propertyHierarchy.isEmpty() || PropertyType.isComplexType(propertyType) && propertyHierarchy.isEmpty() || PropertyType.isContentType(propertyType) && propertyHierarchy.isEmpty()) {
                        propertyHierarchy.add(new PropertyHierarchyNode(propertyType, null));
                    }
                }
                currentNode = parentNode;
                currentNodeName = currentNode.getNodeName();
            }
            if (parentNode != null && field != null && !propertyHierarchy.isEmpty()) {
                Node nameAttr;
                String schema = currentNodeName;
                NamedNodeMap attr = currentNode.getAttributes();
                if (attr != null && attr.getLength() > 0 && (nameAttr = attr.getNamedItem(NAME_ATTRIBUTE)) != null) {
                    schema = nameAttr.getNodeValue();
                }
                Collections.reverse(propertyHierarchy);
                LOGGER.debug((Object)String.format("Found field difference #%d on [%s]/[%s] with hierarchy %s: [%s (%s)] {%s --> %s}", fieldDifferenceCount + 1, schema, field, propertyHierarchy, difference.getDescription(), difference.getId(), controlNodeDetail.getValue(), testNodeDetail.getValue()));
                FieldDiffHelper.computeFieldDiff(docDiff, schema, field, propertyHierarchy, difference.getId(), controlNodeDetail, testNodeDetail);
                return true;
            }
            LOGGER.debug((Object)String.format("Found non-field difference: [%s (%s)] {%s --> %s}", difference.getDescription(), difference.getId(), controlNodeDetail.getValue(), testNodeDetail.getValue()));
        }
        return false;
    }

    public static String getPropertyType(Node node) {
        Node type;
        String propertyType = "undefined";
        NamedNodeMap nodeAttr = node.getAttributes();
        if (nodeAttr != null && (type = nodeAttr.getNamedItem(TYPE_ATTRIBUTE)) != null) {
            propertyType = type.getNodeValue();
        }
        return propertyType;
    }

    private static int getNodePosition(Node node) {
        int nodePos = 0;
        for (Node previousSibling = node.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
            ++nodePos;
        }
        return nodePos;
    }

    public static PropertyDiff applyPropertyHierarchyToDiff(PropertyDiff firstPropertyDiff, List<PropertyHierarchyNode> propertyHierarchy) {
        if (propertyHierarchy.isEmpty()) {
            throw new NuxeoException("Empty property hierarchy.");
        }
        PropertyHierarchyNode propertyHierarchyNode = propertyHierarchy.get(0);
        String firstPropertyType = propertyHierarchyNode.getNodeType();
        String firstPropertyValue = propertyHierarchyNode.getNodeValue();
        if ((PropertyType.isSimpleType(firstPropertyType) || PropertyType.isContentType(firstPropertyType)) && propertyHierarchy.size() > 1) {
            throw new NuxeoException(String.format("Inconsistant property hierarchy %s.", propertyHierarchy));
        }
        PropertyDiff propertyDiff = firstPropertyDiff;
        String propertyType = firstPropertyType;
        String propertyValue = firstPropertyValue;
        for (int i = 1; i < propertyHierarchy.size(); ++i) {
            PropertyDiff childPropertyDiff = null;
            PropertyHierarchyNode childPropertyHierarchyNode = propertyHierarchy.get(i);
            String childPropertyType = childPropertyHierarchyNode.getNodeType();
            String childPropertyValue = childPropertyHierarchyNode.getNodeValue();
            if (!PropertyType.isSimpleType(propertyType) && !PropertyType.isContentType(propertyType)) {
                if (PropertyType.isListType(propertyType)) {
                    int propertyIndex = Integer.parseInt(propertyValue);
                    childPropertyDiff = ((ListPropertyDiff)propertyDiff).getDiff(propertyIndex);
                    if (childPropertyDiff == null) {
                        childPropertyDiff = FieldDiffHelper.newPropertyDiff(childPropertyType);
                        ((ListPropertyDiff)propertyDiff).putDiff(propertyIndex, childPropertyDiff);
                    }
                    propertyDiff = childPropertyDiff;
                } else {
                    childPropertyDiff = ((ComplexPropertyDiff)propertyDiff).getDiff(propertyValue);
                    if (childPropertyDiff == null) {
                        childPropertyDiff = FieldDiffHelper.newPropertyDiff(childPropertyType);
                        ((ComplexPropertyDiff)propertyDiff).putDiff(propertyValue, childPropertyDiff);
                    }
                    propertyDiff = childPropertyDiff;
                }
            }
            propertyType = childPropertyType;
            propertyValue = childPropertyValue;
        }
        return propertyDiff;
    }

    private static void computeFieldDiff(DocumentDiff docDiff, String schema, String field, List<PropertyHierarchyNode> propertyHierarchy, int differenceId, NodeDetail controlNodeDetail, NodeDetail testNodeDetail) {
        PropertyDiff fieldDiff;
        if (propertyHierarchy.isEmpty()) {
            throw new NuxeoException("Empty property hierarchy.");
        }
        PropertyHierarchyNode propertyHierarchyNode = propertyHierarchy.get(0);
        String firstPropertyType = propertyHierarchyNode.getNodeType();
        SchemaDiff schemaDiff = docDiff.getSchemaDiff(schema);
        if (schemaDiff == null) {
            schemaDiff = docDiff.initSchemaDiff(schema);
        }
        if ((fieldDiff = schemaDiff.getFieldDiff(field)) == null) {
            fieldDiff = FieldDiffHelper.newPropertyDiff(firstPropertyType);
        }
        PropertyDiff endPropertyDiff = fieldDiff;
        if (!PropertyType.isSimpleType(firstPropertyType)) {
            endPropertyDiff = FieldDiffHelper.applyPropertyHierarchyToDiff(fieldDiff, propertyHierarchy);
        }
        switch (differenceId) {
            case 14: {
                FieldDiffHelper.computeTextValueDiff(endPropertyDiff, controlNodeDetail, testNodeDetail);
                break;
            }
            case 22: {
                FieldDiffHelper.computeChildNodeNotFoundDiff(endPropertyDiff, controlNodeDetail, testNodeDetail);
                break;
            }
            case 18: {
                FieldDiffHelper.computeHasChildNodesDiff(endPropertyDiff, controlNodeDetail, testNodeDetail);
                break;
            }
            default: {
                FieldDiffHelper.computeTextValueDiff(endPropertyDiff, controlNodeDetail, testNodeDetail);
            }
        }
        schemaDiff.putFieldDiff(field, fieldDiff);
    }

    private static PropertyDiff newPropertyDiff(String propertyType) {
        if (PropertyType.isSimpleType(propertyType)) {
            return new SimplePropertyDiff(propertyType);
        }
        if (PropertyType.isListType(propertyType)) {
            return new ListPropertyDiff(propertyType);
        }
        if (PropertyType.isComplexType(propertyType)) {
            return new ComplexPropertyDiff();
        }
        return new ContentPropertyDiff();
    }

    private static void computeTextValueDiff(PropertyDiff fieldDiff, NodeDetail controlNodeDetail, NodeDetail testNodeDetail) {
        String leftValue = controlNodeDetail.getValue();
        String rightValue = testNodeDetail.getValue();
        Node controlNode = controlNodeDetail.getNode();
        if (controlNode == null) {
            throw new NuxeoException("Control node should never be null.");
        }
        Node controlParentNode = controlNode.getParentNode();
        if (controlParentNode == null) {
            throw new NuxeoException("Control parent node should never be null.");
        }
        String controlParentNodePropertyType = FieldDiffHelper.getPropertyType(controlParentNode);
        String fieldDiffPropertyType = fieldDiff.getPropertyType();
        if (PropertyType.isSimpleType(fieldDiffPropertyType)) {
            ((SimplePropertyDiff)fieldDiff).setLeftValue(leftValue);
            ((SimplePropertyDiff)fieldDiff).setRightValue(rightValue);
        } else if (PropertyType.isListType(fieldDiffPropertyType)) {
            ((ListPropertyDiff)fieldDiff).putDiff(FieldDiffHelper.getNodePosition(controlParentNode), new SimplePropertyDiff(controlParentNodePropertyType, leftValue, rightValue));
        } else if (PropertyType.isComplexType(fieldDiffPropertyType)) {
            ((ComplexPropertyDiff)fieldDiff).putDiff(controlParentNode.getNodeName(), new SimplePropertyDiff(controlParentNodePropertyType, leftValue, rightValue));
        } else {
            ContentPropertyDiff contentPropertyDiff = (ContentPropertyDiff)fieldDiff;
            FieldDiffHelper.setContentSubPropertyDiff(contentPropertyDiff, controlParentNode.getNodeName(), leftValue, rightValue);
        }
    }

    private static void computeChildNodeNotFoundDiff(PropertyDiff fieldDiff, NodeDetail controlNodeDetail, NodeDetail testNodeDetail) {
        boolean isTestNodeNotFound = "null".equals(testNodeDetail.getValue());
        Node childNode = !isTestNodeNotFound ? testNodeDetail.getNode() : controlNodeDetail.getNode();
        if (childNode == null) {
            throw new NuxeoException("Child node should never be null.");
        }
        String propertyType = fieldDiff.getPropertyType();
        if (PropertyType.isSimpleType(propertyType)) {
            throw new NuxeoException("A CHILD_NODE_NOT_FOUND difference should never be found within a simple type.");
        }
        if (!PropertyType.isListType(propertyType)) {
            if (PropertyType.isComplexType(propertyType)) {
                throw new NuxeoException("A CHILD_NODE_NOT_FOUND difference should never be found within a complex type.");
            }
            throw new NuxeoException("A CHILD_NODE_NOT_FOUND difference should never be found within a content type.");
        }
        PropertyDiff childNodeDiff = FieldDiffHelper.getChildNodePropertyDiff(childNode, isTestNodeNotFound);
        ((ListPropertyDiff)fieldDiff).putDiff(FieldDiffHelper.getNodePosition(childNode), childNodeDiff);
    }

    private static void computeHasChildNodesDiff(PropertyDiff fieldDiff, NodeDetail controlNodeDetail, NodeDetail testNodeDetail) {
        boolean hasControlNodeChildNodes = Boolean.valueOf(controlNodeDetail.getValue());
        Node nodeWithChildren = hasControlNodeChildNodes ? controlNodeDetail.getNode() : testNodeDetail.getNode();
        if (nodeWithChildren == null) {
            throw new NuxeoException("Node with children should never be null.");
        }
        String propertyType = fieldDiff.getPropertyType();
        if (PropertyType.isSimpleType(propertyType)) {
            FieldDiffHelper.setSimplePropertyDiff((SimplePropertyDiff)fieldDiff, nodeWithChildren, hasControlNodeChildNodes);
        } else if (PropertyType.isListType(propertyType)) {
            PropertyDiff childNodeDiff = FieldDiffHelper.getChildNodePropertyDiff(nodeWithChildren, hasControlNodeChildNodes);
            if (PropertyType.isListType(FieldDiffHelper.getPropertyType(nodeWithChildren))) {
                ((ListPropertyDiff)fieldDiff).putAllDiff((ListPropertyDiff)childNodeDiff);
            } else {
                ((ListPropertyDiff)fieldDiff).putDiff(FieldDiffHelper.getNodePosition(nodeWithChildren), childNodeDiff);
            }
        } else if (PropertyType.isComplexType(propertyType)) {
            PropertyDiff childNodeDiff = FieldDiffHelper.getChildNodePropertyDiff(nodeWithChildren, hasControlNodeChildNodes);
            if (PropertyType.isComplexType(FieldDiffHelper.getPropertyType(nodeWithChildren))) {
                ((ComplexPropertyDiff)fieldDiff).putAllDiff((ComplexPropertyDiff)childNodeDiff);
            } else {
                ((ComplexPropertyDiff)fieldDiff).putDiff(nodeWithChildren.getNodeName(), childNodeDiff);
            }
        } else if (PropertyType.isContentType(FieldDiffHelper.getPropertyType(nodeWithChildren))) {
            PropertyDiff childNodeDiff = FieldDiffHelper.getChildNodePropertyDiff(nodeWithChildren, hasControlNodeChildNodes);
            ((ContentPropertyDiff)fieldDiff).setLeftContent(((ContentPropertyDiff)childNodeDiff).getLeftContent());
            ((ContentPropertyDiff)fieldDiff).setRightContent(((ContentPropertyDiff)childNodeDiff).getRightContent());
        } else {
            FieldDiffHelper.setContentPropertyDiff((ContentPropertyDiff)fieldDiff, nodeWithChildren, hasControlNodeChildNodes);
        }
    }

    private static PropertyDiff getChildNodePropertyDiff(Node node, boolean hasControlNodeChildNodes) {
        PropertyDiff propertyDiff;
        String nodePropertyType = FieldDiffHelper.getPropertyType(node);
        if (PropertyType.isSimpleType(nodePropertyType)) {
            propertyDiff = new SimplePropertyDiff(nodePropertyType);
            FieldDiffHelper.setSimplePropertyDiff(propertyDiff, node, hasControlNodeChildNodes);
        } else if (PropertyType.isListType(nodePropertyType)) {
            propertyDiff = new ListPropertyDiff(nodePropertyType);
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                ((ListPropertyDiff)propertyDiff).putDiff(i, FieldDiffHelper.getChildNodePropertyDiff(childNodes.item(i), hasControlNodeChildNodes));
            }
        } else if (PropertyType.isComplexType(nodePropertyType)) {
            propertyDiff = new ComplexPropertyDiff();
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                ((ComplexPropertyDiff)propertyDiff).putDiff(childNode.getNodeName(), FieldDiffHelper.getChildNodePropertyDiff(childNode, hasControlNodeChildNodes));
            }
        } else {
            propertyDiff = new ContentPropertyDiff();
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                FieldDiffHelper.setContentPropertyDiff((ContentPropertyDiff)propertyDiff, childNode, hasControlNodeChildNodes);
            }
        }
        return propertyDiff;
    }

    private static void setSimplePropertyDiff(SimplePropertyDiff fieldDiff, Node textNode, boolean hasControlNodeContent) {
        String textNodeValue = textNode.getTextContent();
        String leftValue = hasControlNodeContent ? textNodeValue : null;
        String rightValue = hasControlNodeContent ? null : textNodeValue;
        fieldDiff.setLeftValue(leftValue);
        fieldDiff.setRightValue(rightValue);
    }

    private static void setContentPropertyDiff(ContentPropertyDiff fieldDiff, Node textNode, boolean hasControlNodeContent) {
        String textNodeValue = textNode.getTextContent();
        String leftValue = hasControlNodeContent ? textNodeValue : null;
        String rightValue = hasControlNodeContent ? null : textNodeValue;
        FieldDiffHelper.setContentSubPropertyDiff(fieldDiff, textNode.getNodeName(), leftValue, rightValue);
    }

    protected static void setContentSubPropertyDiff(ContentPropertyDiff fieldDiff, String subPropertyName, String leftSubPropertyValue, String rightSubPropertyValue) {
        ContentProperty leftContent = fieldDiff.getLeftContent();
        ContentProperty rightContent = fieldDiff.getRightContent();
        if (leftContent == null) {
            leftContent = new ContentProperty();
            fieldDiff.setLeftContent(leftContent);
        }
        if (rightContent == null) {
            rightContent = new ContentProperty();
            fieldDiff.setRightContent(rightContent);
        }
        leftContent.setSubProperty(subPropertyName, leftSubPropertyValue);
        rightContent.setSubProperty(subPropertyName, rightSubPropertyValue);
        if ("filename".equals(subPropertyName)) {
            if (DifferenceType.differentDigest.equals((Object)fieldDiff.getDifferenceType())) {
                fieldDiff.setDifferenceType(DifferenceType.different);
            } else {
                fieldDiff.setDifferenceType(DifferenceType.differentFilename);
            }
        } else if ("digest".equals(subPropertyName)) {
            if (DifferenceType.differentFilename.equals((Object)fieldDiff.getDifferenceType())) {
                fieldDiff.setDifferenceType(DifferenceType.different);
            } else {
                fieldDiff.setDifferenceType(DifferenceType.differentDigest);
            }
        }
    }
}

