/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class BatchFinderWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BatchFinderWork.class);
    protected static final int SCROLL_KEEPALIVE_SECONDS = 60;
    protected String nxql;

    public BatchFinderWork(String repositoryName, String nxql, String originatingUsername) {
        this.repositoryName = repositoryName;
        this.nxql = nxql;
        this.setOriginatingUsername(originatingUsername);
    }

    public int getRetryCount() {
        return 1;
    }

    public abstract int getBatchSize();

    public void work() {
        int batchSize = this.getBatchSize();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getTitle() + ": Starting batch find for query: " + this.nxql + " with batch size: " + batchSize));
        }
        this.openSystemSession();
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Searching");
        long batchCount = 0L;
        long documentCount = 0L;
        ScrollResult scroll = this.session.scroll(this.nxql, batchSize, 60);
        while (scroll.hasResults()) {
            List docIds = scroll.getResults();
            if (!docIds.isEmpty()) {
                ((WorkManager)Framework.getService(WorkManager.class)).schedule(this.getBatchProcessorWork(docIds));
            }
            ++batchCount;
            this.setProgress(new Work.Progress(documentCount += (long)docIds.size(), -1L));
            scroll = this.session.scroll(scroll.getScrollId());
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getTitle() + ": Submitted " + documentCount + " documents in " + batchCount + " batch processor workers"));
        }
        this.setProgress(new Work.Progress(documentCount, documentCount));
        this.setStatus("Done");
    }

    public abstract Work getBatchProcessorWork(List<String> var1);
}

