/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.local.LocalSession;
import org.nuxeo.runtime.model.DefaultComponent;

public class CoreSessionServiceImpl
extends DefaultComponent
implements CoreSessionService {
    private final Map<String, CoreSessionService.CoreSessionRegistrationInfo> sessions = new ConcurrentHashMap<String, CoreSessionService.CoreSessionRegistrationInfo>();

    public CoreSession createCoreSession(String repositoryName, NuxeoPrincipal principal) {
        LocalSession session = new LocalSession(repositoryName, principal);
        this.sessions.put(session.getSessionId(), new CoreSessionService.CoreSessionRegistrationInfo((CoreSession)session));
        return session;
    }

    public void releaseCoreSession(CoreSession session) {
        String sessionId = session.getSessionId();
        CoreSessionService.CoreSessionRegistrationInfo info = this.sessions.remove(sessionId);
        if (info == null) {
            throw new RuntimeException("Closing unknown CoreSession: " + sessionId, (Throwable)info);
        }
        session.destroy();
    }

    public CoreSession getCoreSession(String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("null sessionId");
        }
        CoreSessionService.CoreSessionRegistrationInfo info = this.sessions.get(sessionId);
        return info == null ? null : info.getCoreSession();
    }

    public int getNumberOfOpenCoreSessions() {
        return this.sessions.size();
    }

    public List<CoreSessionService.CoreSessionRegistrationInfo> getCoreSessionRegistrationInfos() {
        return new ArrayList<CoreSessionService.CoreSessionRegistrationInfo>(this.sessions.values());
    }
}

