/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.security.Principal;
import java.util.Arrays;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class CheckInSecurityPolicy
extends AbstractSecurityPolicy {
    @Override
    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        Access access = Access.UNKNOWN;
        if (Arrays.asList(resolvedPermissions).contains("WriteProperties") && !doc.isVersion() && !doc.isProxy() && !doc.isCheckedOut()) {
            access = Access.DENY;
        }
        return access;
    }

    @Override
    public boolean isRestrictingPermission(String permission) {
        return permission.equals("Write");
    }

    @Override
    public boolean isExpressibleInQuery(String repositoryName) {
        return true;
    }

    @Override
    public SQLQuery.Transformer getQueryTransformer(String repositoryName) {
        return SQLQuery.Transformer.IDENTITY;
    }
}

