/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.versioning.VersionRemovalPolicy;
import org.nuxeo.runtime.api.Framework;

public class DefaultVersionRemovalPolicy
implements VersionRemovalPolicy {
    private static final Log log = LogFactory.getLog(DefaultVersionRemovalPolicy.class);
    public static final String ORPHAN_VERSION_REMOVE = "orphan_versions_to_remove";

    @Override
    public void removeVersions(Session session, Document doc, CoreSession coreSession) {
        List<Document> proxies = session.getProxies(doc, null);
        if (doc.isProxy()) {
            proxies.remove(doc);
            if (proxies.isEmpty()) {
                Document source = doc.getSourceDocument();
                if (source.isVersion()) {
                    try {
                        source = source.getSourceDocument();
                    }
                    catch (DocumentNotFoundException e) {
                        source = null;
                    }
                }
                if (source != null) {
                    return;
                }
            }
        }
        if (proxies.isEmpty()) {
            List<String> versionsIds = doc.getVersionsIds();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Removing %s versions for: %s", versionsIds.size(), doc.getUUID()));
            }
            if (versionsIds.size() > 0) {
                DocumentModel docModel = coreSession.getDocument((DocumentRef)new IdRef(doc.getUUID()));
                EventContextImpl evtctx = new EventContextImpl(coreSession, coreSession.getPrincipal(), new Object[]{new ShallowDocumentModel(docModel), versionsIds});
                Event evt = evtctx.newEvent(ORPHAN_VERSION_REMOVE);
                ((EventService)Framework.getService(EventService.class)).fireEvent(evt);
            }
        }
    }
}

