/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.nxql;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.search.api.client.querymodel.Escaper;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.core.FieldDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class NXQLQueryBuilder {
    public static final String DEFAULT_SELECT_STATEMENT = "SELECT * FROM Document";
    public static final String SORTED_COLUMN = "SORTED_COLUMN";
    public static final String REGEXP_NAMED_PARAMETER = "[^a-zA-Z]:\\s*([a-zA-Z0-9:]*)";
    public static final String REGEXP_EXCLUDE_QUOTE = "'[^']*'";
    public static final String REGEXP_EXCLUDE_DOUBLE_QUOTE = "\"[^\"]*\"";
    public static final String DEFAULT_SPECIAL_CHARACTERS_REGEXP = "!#$%&'()+,./\\\\:-@{|}`^~";
    public static final String IGNORED_CHARS_KEY = "org.nuxeo.query.builder.ignored.chars";

    private NXQLQueryBuilder() {
    }

    public static String getSortClause(SortInfo ... sortInfos) {
        StringBuilder queryBuilder = new StringBuilder();
        if (sortInfos != null) {
            int index = 0;
            for (SortInfo sortInfo : sortInfos) {
                String sortColumn = sortInfo.getSortColumn();
                boolean sortAscending = sortInfo.getSortAscending();
                if (index == 0) {
                    queryBuilder.append("ORDER BY ").append(sortColumn).append(' ').append(sortAscending ? "" : "DESC");
                } else {
                    queryBuilder.append(", ").append(sortColumn).append(' ').append(sortAscending ? "" : "DESC");
                }
                ++index;
            }
        }
        return queryBuilder.toString();
    }

    public static String getQuery(DocumentModel model, WhereClauseDefinition whereClause, Object[] params, SortInfo ... sortInfos) {
        return NXQLQueryBuilder.getQuery(model, whereClause, null, params, sortInfos);
    }

    public static String getQuery(DocumentModel model, WhereClauseDefinition whereClause, String quickFiltersClause, Object[] params, SortInfo ... sortInfos) {
        StringBuilder queryBuilder = new StringBuilder();
        String selectStatement = whereClause.getSelectStatement();
        if (StringUtils.isBlank((String)selectStatement)) {
            selectStatement = DEFAULT_SELECT_STATEMENT;
        }
        queryBuilder.append(selectStatement);
        queryBuilder.append(NXQLQueryBuilder.getQueryElement(model, whereClause, quickFiltersClause, params));
        String sortClause = NXQLQueryBuilder.getSortClause(sortInfos);
        if (sortClause.length() > 0) {
            queryBuilder.append(" ");
            queryBuilder.append(sortClause);
        }
        return queryBuilder.toString().trim();
    }

    public static String getQueryElement(DocumentModel model, WhereClauseDefinition whereClause, Object[] params) {
        return NXQLQueryBuilder.getQueryElement(model, whereClause, null, params);
    }

    public static String getQueryElement(DocumentModel model, WhereClauseDefinition whereClause, String quickFiltersClause, Object[] params) {
        String fixedPart;
        ArrayList<String> elements = new ArrayList<String>();
        PredicateDefinition[] predicates = whereClause.getPredicates();
        if (predicates != null) {
            Escaper escaper = null;
            Class escaperClass = whereClause.getEscaperClass();
            if (escaperClass != null) {
                try {
                    escaper = (Escaper)escaperClass.newInstance();
                }
                catch (ReflectiveOperationException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            for (PredicateDefinition predicate : predicates) {
                String predicateString = NXQLQueryBuilder.getQueryElement(model, predicate, escaper);
                if (predicateString == null || (predicateString = predicateString.trim()).equals("")) continue;
                elements.add(predicateString);
            }
        }
        if (!StringUtils.isBlank((String)(fixedPart = whereClause.getFixedPart()))) {
            if (StringUtils.isNotBlank((String)quickFiltersClause)) {
                fixedPart = NXQLQueryBuilder.appendClause(fixedPart, quickFiltersClause);
            }
            if (elements.isEmpty()) {
                elements.add(NXQLQueryBuilder.getQuery(fixedPart, params, whereClause.getQuoteFixedPartParameters(), whereClause.getEscapeFixedPartParameters(), model, new SortInfo[0]));
            } else {
                elements.add('(' + NXQLQueryBuilder.getQuery(fixedPart, params, whereClause.getQuoteFixedPartParameters(), whereClause.getEscapeFixedPartParameters(), model, new SortInfo[0]) + ')');
            }
        } else if (StringUtils.isNotBlank((String)quickFiltersClause)) {
            fixedPart = quickFiltersClause;
        }
        if (elements.isEmpty()) {
            return "";
        }
        String clauseValues = StringUtils.join(elements, (String)" AND ").trim();
        while (elements.size() == 1 && clauseValues.startsWith("(") && clauseValues.endsWith(")")) {
            clauseValues = clauseValues.substring(1, clauseValues.length() - 1).trim();
        }
        if (clauseValues.length() == 0) {
            return "";
        }
        return " WHERE " + clauseValues;
    }

    public static String getQuery(String pattern, Object[] params, boolean quoteParameters, boolean escape, DocumentModel searchDocumentModel, SortInfo ... sortInfos) {
        StringBuilder queryBuilder;
        String sortedColumn = sortInfos == null || sortInfos.length == 0 ? "ecm:uuid" : sortInfos[0].getSortColumn();
        if (pattern != null && pattern.contains(SORTED_COLUMN)) {
            pattern = pattern.replace(SORTED_COLUMN, sortedColumn);
        }
        if (searchDocumentModel != null) {
            String query = pattern.replaceAll(REGEXP_EXCLUDE_DOUBLE_QUOTE, "");
            query = query.replaceAll(REGEXP_EXCLUDE_QUOTE, "");
            Pattern p1 = Pattern.compile(REGEXP_NAMED_PARAMETER);
            Matcher m1 = p1.matcher(query);
            ArrayList<String> matches = new ArrayList<String>();
            while (m1.find()) {
                matches.add(m1.group().substring(m1.group().indexOf(":") + 1));
            }
            for (String key : matches) {
                Object parameter = NXQLQueryBuilder.getRawValue(searchDocumentModel, new FieldDescriptor(key));
                if (parameter == null) continue;
                key = ":" + key;
                if (parameter instanceof String[]) {
                    pattern = NXQLQueryBuilder.replaceStringList(pattern, Arrays.asList((String[])parameter), quoteParameters, escape, key);
                    continue;
                }
                if (parameter instanceof List) {
                    pattern = NXQLQueryBuilder.replaceStringList(pattern, (List)parameter, quoteParameters, escape, key);
                    continue;
                }
                if (parameter instanceof Boolean) {
                    pattern = NXQLQueryBuilder.buildPattern(pattern, key, (Boolean)parameter != false ? "1" : "0");
                    continue;
                }
                if (parameter instanceof Number) {
                    pattern = NXQLQueryBuilder.buildPattern(pattern, key, parameter.toString());
                    continue;
                }
                if (parameter instanceof Literal) {
                    if (quoteParameters) {
                        pattern = NXQLQueryBuilder.buildPattern(pattern, key, "'" + parameter.toString() + "'");
                        continue;
                    }
                    pattern = NXQLQueryBuilder.buildPattern(pattern, key, ((Literal)parameter).asString());
                    continue;
                }
                if (quoteParameters) {
                    pattern = NXQLQueryBuilder.buildPattern(pattern, key, "'" + parameter + "'");
                    continue;
                }
                pattern = NXQLQueryBuilder.buildPattern(pattern, key, parameter.toString());
            }
        }
        if (params == null) {
            queryBuilder = new StringBuilder(pattern + ' ');
        } else {
            String[] queryStrList = (pattern + ' ').split("\\?");
            queryBuilder = new StringBuilder(queryStrList[0]);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof String[]) {
                    NXQLQueryBuilder.appendStringList(queryBuilder, Arrays.asList((String[])params[i]), quoteParameters, escape);
                } else if (params[i] instanceof List) {
                    NXQLQueryBuilder.appendStringList(queryBuilder, (List)params[i], quoteParameters, escape);
                } else if (params[i] instanceof Boolean) {
                    boolean b = (Boolean)params[i];
                    queryBuilder.append(b ? 1 : 0);
                } else if (params[i] instanceof Number) {
                    queryBuilder.append(params[i]);
                } else if (params[i] instanceof Literal) {
                    if (quoteParameters) {
                        queryBuilder.append(params[i].toString());
                    } else {
                        queryBuilder.append(((Literal)params[i]).asString());
                    }
                } else if (params[i] == null) {
                    if (quoteParameters) {
                        queryBuilder.append("''");
                    }
                } else {
                    String queryParam = params[i].toString();
                    queryBuilder.append(NXQLQueryBuilder.prepareStringLiteral(queryParam, quoteParameters, escape));
                }
                queryBuilder.append(queryStrList[i + 1]);
            }
        }
        queryBuilder.append(NXQLQueryBuilder.getSortClause(sortInfos));
        return queryBuilder.toString().trim();
    }

    public static void appendStringList(StringBuilder queryBuilder, List<?> listParam, boolean quoteParameters, boolean escape) {
        boolean addParentheses;
        boolean bl = addParentheses = !queryBuilder.toString().endsWith("(");
        if (addParentheses) {
            queryBuilder.append('(');
        }
        ArrayList<String> result = new ArrayList<String>(listParam.size());
        for (Object param : listParam) {
            result.add(NXQLQueryBuilder.prepareStringLiteral(param.toString(), quoteParameters, escape));
        }
        queryBuilder.append(String.join((CharSequence)", ", result));
        if (addParentheses) {
            queryBuilder.append(')');
        }
    }

    public static String replaceStringList(String pattern, List<?> listParams, boolean quoteParameters, boolean escape, String key) {
        ArrayList<String> result = new ArrayList<String>(listParams.size());
        for (Object param : listParams) {
            result.add(NXQLQueryBuilder.prepareStringLiteral(param.toString(), quoteParameters, escape));
        }
        return NXQLQueryBuilder.buildPattern(pattern, key, '(' + StringUtils.join(result, (String)", ") + ')');
    }

    public static String prepareStringLiteral(String s, boolean quoteParameter, boolean escape) {
        if (escape) {
            if (quoteParameter) {
                return NXQL.escapeString((String)s);
            }
            return NXQL.escapeStringInner((String)s);
        }
        if (quoteParameter) {
            return "'" + s + "'";
        }
        return s;
    }

    public static String getQueryElement(DocumentModel model, PredicateDefinition predicateDescriptor, Escaper escaper) {
        String type = predicateDescriptor.getType();
        if ("atomic".equals(type)) {
            return NXQLQueryBuilder.atomicQueryElement(model, predicateDescriptor, escaper);
        }
        if ("subClause".equals(type)) {
            return NXQLQueryBuilder.subClauseQueryElement(model, predicateDescriptor);
        }
        throw new NuxeoException("Unknown predicate type: " + type);
    }

    protected static String subClauseQueryElement(DocumentModel model, PredicateDefinition predicateDescriptor) {
        PredicateFieldDefinition[] values = predicateDescriptor.getValues();
        if (values == null || values.length != 1) {
            throw new NuxeoException("subClause predicate needs exactly one field");
        }
        PredicateFieldDefinition fieldDescriptor = values[0];
        if (!NXQLQueryBuilder.getFieldType(model, fieldDescriptor).equals("string")) {
            if (fieldDescriptor.getXpath() != null) {
                throw new NuxeoException(String.format("type of field %s is not string", fieldDescriptor.getXpath()));
            }
            throw new NuxeoException(String.format("type of field %s.%s is not string", fieldDescriptor.getSchema(), fieldDescriptor.getName()));
        }
        Object subclauseValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (subclauseValue == null) {
            return "";
        }
        return "(" + subclauseValue + ")";
    }

    protected static String atomicQueryElement(DocumentModel model, PredicateDefinition predicateDescriptor, Escaper escaper) {
        FieldDescriptor operatorFieldDescriptor;
        String operator = null;
        String operatorField = predicateDescriptor.getOperatorField();
        String operatorSchema = predicateDescriptor.getOperatorSchema();
        PredicateFieldDefinition[] values = predicateDescriptor.getValues();
        if (operatorField != null && operatorSchema != null && (operator = NXQLQueryBuilder.getPlainStringValue(model, operatorFieldDescriptor = new FieldDescriptor(operatorSchema, operatorField))) != null) {
            operator = operator.toUpperCase();
        }
        if (StringUtils.isBlank(operator)) {
            operator = predicateDescriptor.getOperator();
        }
        String hint = predicateDescriptor.getHint();
        String parameter = NXQLQueryBuilder.getParameterWithHint(operator, predicateDescriptor.getParameter(), hint);
        if (operator.equals("=") || operator.equals("!=") || operator.equals("<") || operator.equals(">") || operator.equals("<=") || operator.equals(">=") || operator.equals("<>") || operator.equals("LIKE") || operator.equals("ILIKE")) {
            String value = NXQLQueryBuilder.getStringValue(model, values[0]);
            if (value == null) {
                return "";
            }
            if (escaper != null && (operator.equals("LIKE") || operator.equals("ILIKE"))) {
                value = escaper.escape(value);
            }
            return NXQLQueryBuilder.serializeUnary(parameter, operator, value);
        }
        if (operator.equals("BETWEEN")) {
            String min = NXQLQueryBuilder.getStringValue(model, values[0]);
            String max = NXQLQueryBuilder.getStringValue(model, values[1]);
            if (min != null && max != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(parameter);
                builder.append(' ');
                builder.append(operator);
                builder.append(' ');
                builder.append(min);
                builder.append(" AND ");
                builder.append(max);
                return builder.toString();
            }
            if (max != null) {
                return NXQLQueryBuilder.serializeUnary(parameter, "<=", max);
            }
            if (min != null) {
                return NXQLQueryBuilder.serializeUnary(parameter, ">=", min);
            }
            return "";
        }
        if (operator.equals("IN")) {
            List<String> options = NXQLQueryBuilder.getListValue(model, values[0]);
            if (options == null || options.isEmpty()) {
                return "";
            }
            if (options.size() == 1) {
                return NXQLQueryBuilder.serializeUnary(parameter, "=", options.get(0));
            }
            StringBuilder builder = new StringBuilder();
            builder.append(parameter);
            builder.append(" IN (");
            for (int i = 0; i < options.size(); ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(options.get(i));
            }
            builder.append(')');
            return builder.toString();
        }
        if (operator.equals("STARTSWITH")) {
            String fieldType = NXQLQueryBuilder.getFieldType(model, values[0]);
            if (fieldType.equals("string")) {
                String value = NXQLQueryBuilder.getStringValue(model, values[0]);
                if (value == null) {
                    return "";
                }
                return NXQLQueryBuilder.serializeUnary(parameter, operator, value);
            }
            List<String> options = NXQLQueryBuilder.getListValue(model, values[0]);
            if (options == null || options.isEmpty()) {
                return "";
            }
            if (options.size() == 1) {
                return NXQLQueryBuilder.serializeUnary(parameter, operator, options.get(0));
            }
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            for (int i = 0; i < options.size() - 1; ++i) {
                builder.append(NXQLQueryBuilder.serializeUnary(parameter, operator, options.get(i)));
                builder.append(" OR ");
            }
            builder.append(NXQLQueryBuilder.serializeUnary(parameter, operator, options.get(options.size() - 1)));
            builder.append(')');
            return builder.toString();
        }
        if (operator.equals("EMPTY") || operator.equals("ISEMPTY")) {
            return parameter + " = ''";
        }
        if (operator.equals("FULLTEXT ALL") || operator.equals("FULLTEXT")) {
            String value = NXQLQueryBuilder.getPlainStringValue(model, values[0]);
            if (value == null) {
                return "";
            }
            if (escaper != null) {
                value = escaper.escape(value);
            }
            return parameter + ' ' + NXQLQueryBuilder.serializeFullText(value);
        }
        if (operator.equals("IS NULL")) {
            Boolean value = NXQLQueryBuilder.getBooleanValue(model, values[0]);
            if (value == null) {
                return "";
            }
            if (Boolean.TRUE.equals(value)) {
                return parameter + " IS NULL";
            }
            return parameter + " IS NOT NULL";
        }
        throw new NuxeoException("Unsupported operator: " + operator);
    }

    protected static String getParameterWithHint(String operator, String parameter, String hint) {
        String ret = parameter;
        if ((operator.equals("FULLTEXT ALL") || operator.equals("FULLTEXT")) && !parameter.startsWith("ecm:fulltext")) {
            ret = "ecm:fulltext." + parameter;
        }
        if (hint != null && !hint.isEmpty()) {
            ret = String.format("/*+%s */ %s", hint.trim(), ret);
        }
        return ret;
    }

    public static String sanitizeFulltextInput(String value) {
        String[] tokens;
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        String ignoredChars = cs.getProperty(IGNORED_CHARS_KEY, DEFAULT_SPECIAL_CHARACTERS_REGEXP);
        String res = "";
        value = value.replaceAll("[" + ignoredChars + "]", " ");
        value = value.trim();
        for (String token : tokens = value.split("[\\s]+")) {
            if ("-".equals(token) || "*".equals(token) || "*-".equals(token) || "-*".equals(token)) continue;
            if (res.length() > 0) {
                res = res + " ";
            }
            res = token.startsWith("-") || token.endsWith("*") ? res + token : res + token.replace("-", " ").replace("*", " ");
        }
        return res.trim();
    }

    public static String serializeFullText(String value) {
        value = NXQLQueryBuilder.sanitizeFulltextInput(value);
        return "= " + NXQL.escapeString((String)value);
    }

    protected static String serializeUnary(String parameter, String operator, String rvalue) {
        StringBuilder builder = new StringBuilder();
        builder.append(parameter);
        builder.append(' ');
        builder.append(operator);
        builder.append(' ');
        builder.append(rvalue);
        return builder.toString();
    }

    public static String getPlainStringValue(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        String value = (String)rawValue;
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    public static Integer getIntValue(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null || "".equals(rawValue)) {
            return null;
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        if (rawValue instanceof String) {
            return Integer.valueOf((String)rawValue);
        }
        return Integer.valueOf(rawValue.toString());
    }

    public static String getFieldType(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        String xpath = fieldDescriptor.getXpath();
        String schema = fieldDescriptor.getSchema();
        String name = fieldDescriptor.getName();
        try {
            SchemaManager typeManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Field field = null;
            if (xpath != null) {
                if (model != null) {
                    field = model.getProperty(xpath).getField();
                }
            } else if (schema != null) {
                Schema schemaObj = typeManager.getSchema(schema);
                if (schemaObj == null) {
                    throw new NuxeoException("failed to obtain schema: " + schema);
                }
                field = schemaObj.getField(name);
            } else {
                return "string";
            }
            if (field == null) {
                throw new NuxeoException("failed to obtain field: " + schema + ":" + name);
            }
            Type type = field.getType();
            if (type instanceof SimpleTypeImpl) {
                type = type.getSuperType();
            }
            return type.getName();
        }
        catch (PropertyException e) {
            e.addInfo("failed to get field type for " + (xpath != null ? xpath : schema + ":" + name));
            throw e;
        }
    }

    public static Object getRawValue(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        String xpath = fieldDescriptor.getXpath();
        String schema = fieldDescriptor.getSchema();
        String name = fieldDescriptor.getName();
        try {
            if (xpath != null) {
                return model.getPropertyValue(xpath);
            }
            if (schema == null) {
                return model.getPropertyValue(name);
            }
            return model.getProperty(schema, name);
        }
        catch (PropertyNotFoundException e) {
            Map params = (Map)((Object)model.getContextData("namedParameters"));
            if (params != null) {
                if (xpath != null) {
                    return params.get(xpath);
                }
                return params.get(name);
            }
        }
        catch (PropertyException e) {
            return null;
        }
        return null;
    }

    public static String getStringValue(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        String value;
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)rawValue;
            value = "TIMESTAMP '" + NXQLQueryBuilder.getDateFormat().format(gc.getTime()) + "'";
        } else if (rawValue instanceof Date) {
            Date date = (Date)rawValue;
            value = "TIMESTAMP '" + NXQLQueryBuilder.getDateFormat().format(date) + "'";
        } else if (rawValue instanceof Integer || rawValue instanceof Long || rawValue instanceof Double) {
            value = rawValue.toString();
        } else if (rawValue instanceof Boolean) {
            value = (Boolean)rawValue != false ? "1" : "0";
        } else {
            String value2 = rawValue.toString().trim();
            if (value2.equals("")) {
                return null;
            }
            String fieldType = NXQLQueryBuilder.getFieldType(model, fieldDescriptor);
            if ("long".equals(fieldType) || "integer".equals(fieldType) || "double".equals(fieldType)) {
                return value2;
            }
            return NXQL.escapeString((String)value2);
        }
        return value;
    }

    protected static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static List<String> getListValue(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        Object[] rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        if (rawValue instanceof ArrayList) {
            rawValue = ((ArrayList)rawValue).toArray();
        }
        for (Object element : (Object[])rawValue) {
            if (element == null) continue;
            if (element instanceof Number) {
                values.add(element.toString());
                continue;
            }
            String value = element.toString().trim();
            if (value.equals("")) continue;
            values.add(NXQL.escapeString((String)value));
        }
        return values;
    }

    public static Boolean getBooleanValue(DocumentModel model, PredicateFieldDefinition fieldDescriptor) {
        Object rawValue = NXQLQueryBuilder.getRawValue(model, fieldDescriptor);
        if (rawValue == null) {
            return null;
        }
        return (Boolean)rawValue;
    }

    public static String appendClause(String query, String clause) {
        return query + " AND " + clause;
    }

    public static String buildPattern(String pattern, String key, String replacement) {
        int index = pattern.indexOf(key);
        while (index >= 0) {
            if (!(Character.isLetterOrDigit(pattern.charAt(index - 1)) || index + key.length() != pattern.length() && Character.isLetterOrDigit(pattern.charAt(index + key.length())))) {
                pattern = pattern.substring(0, index) + pattern.substring(index).replaceFirst(key, replacement);
            }
            index = pattern.indexOf(key, index + 1);
        }
        return pattern;
    }
}

