/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.queue.impl.table.SingleTableStore;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class SingleTableBuilder {
    public static final String SUFFIX = ".cq4t";
    @NotNull
    private final File file;
    private WireType wireType;
    private boolean readOnly;
    private StoreRecoveryFactory recoverySupplier = TimedStoreRecovery::new;
    private long timeoutMS = TimeUnit.SECONDS.toMillis(5L);

    private SingleTableBuilder(@NotNull File path) {
        this.file = path;
    }

    @NotNull
    public static SingleTableBuilder builder(@NotNull Path path, @NotNull WireType wireType) {
        return SingleTableBuilder.builder(path.toFile(), wireType);
    }

    @NotNull
    public static SingleTableBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Tables should be configured with the table file, not a directory. Actual file used: " + file.getParentFile());
        }
        if (!file.getName().endsWith(SUFFIX)) {
            throw new IllegalArgumentException("Invalid file type: " + file.getName());
        }
        return new SingleTableBuilder(file).wireType(wireType);
    }

    @NotNull
    public static SingleTableBuilder binary(@NotNull Path path) {
        return SingleTableBuilder.binary(path.toFile());
    }

    @NotNull
    public static SingleTableBuilder binary(@NotNull String file) {
        return SingleTableBuilder.binary(new File(file));
    }

    @NotNull
    public static SingleTableBuilder binary(@NotNull File basePathFile) {
        return SingleTableBuilder.builder(basePathFile, WireType.BINARY_LIGHT);
    }

    @NotNull
    public TableStore build() {
        if (this.readOnly && !this.file.exists()) {
            throw new IORuntimeException("File not found in readOnly mode");
        }
        try {
            MappedBytes bytes = MappedBytes.mappedBytes((File)this.file, (long)65536L, (long)0L, (boolean)this.readOnly);
            Wire wire = (Wire)this.wireType.apply((Object)bytes);
            StoreRecovery recovery = (StoreRecovery)this.recoverySupplier.apply(this.wireType);
            try {
                TableStore tableStore;
                if (!this.readOnly && wire.writeFirstHeader()) {
                    tableStore = this.writeTableStore(bytes, wire, recovery);
                } else {
                    wire.readFirstHeader(this.timeoutMS, TimeUnit.MILLISECONDS);
                    StringBuilder name = Wires.acquireStringBuilder();
                    ValueIn valueIn = wire.readEventName(name);
                    if (StringUtils.isEqual(name, MetaDataKeys.header.name())) {
                        tableStore = (TableStore)valueIn.typedMarshallable();
                    } else {
                        throw new StreamCorruptedException("The first message should be the header, was " + name);
                    }
                }
                return tableStore;
            }
            catch (TimeoutException e) {
                recovery.recoverAndWriteHeader(wire, 0, 10000L, null);
                return this.writeTableStore(bytes, wire, recovery);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @NotNull
    private TableStore writeTableStore(MappedBytes bytes, Wire wire, StoreRecovery recovery) throws EOFException, StreamCorruptedException {
        SingleTableStore store = new SingleTableStore(this.wireType, bytes, recovery);
        wire.writeEventName((CharSequence)"header").object((Object)store);
        wire.updateFirstHeader();
        return store;
    }

    @NotNull
    public SingleTableBuilder clone() {
        try {
            SingleTableBuilder clone = (SingleTableBuilder)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public File file() {
        return this.file;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public SingleTableBuilder wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public SingleTableBuilder readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public SingleTableBuilder recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        this.recoverySupplier = recoverySupplier;
        return this;
    }

    public long timeoutMS() {
        return this.timeoutMS;
    }

    public SingleTableBuilder timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(WireType.class);
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleTableStore.class, "STStore");
        ClassAliasPool.CLASS_ALIASES.addAlias(TimedStoreRecovery.class);
    }
}

