/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.nuxeo.runtime.reload.ReloadContext;
import org.nuxeo.runtime.reload.ReloadResult;
import org.nuxeo.runtime.service.TimestampedService;
import org.osgi.framework.BundleException;

public interface ReloadService
extends TimestampedService {
    public static final String RELOAD_TOPIC = "org.nuxeo.runtime.reload";
    public static final String FLUSH_EVENT_ID = "flush";
    public static final String BEFORE_RELOAD_EVENT_ID = "before-reload";
    public static final String RELOAD_EVENT_ID = "reload";
    public static final String AFTER_RELOAD_EVENT_ID = "after-reload";
    public static final String FLUSH_SEAM_EVENT_ID = "flushSeamComponents";
    public static final String RELOAD_SEAM_EVENT_ID = "reloadSeamComponents";
    public static final String USE_COMPAT_HOT_RELOAD = "nuxeo.hotreload.compat.mechanism";

    public void reload() throws InterruptedException;

    public void reloadProperties() throws IOException;

    public void reloadSeamComponents();

    public void flush();

    public Long lastFlushed();

    public void flushJaasCache();

    public void flushSeamComponents();

    @Deprecated
    default public void deployBundle(File file) throws BundleException {
        this.deployBundle(file, false);
    }

    @Deprecated
    default public void deployBundle(File file, boolean reloadResources) throws BundleException {
        this.deployBundles(Collections.singletonList(file), reloadResources);
    }

    @Deprecated
    default public void deployBundles(List<File> files) throws BundleException {
        this.deployBundles(files, false);
    }

    @Deprecated
    public void deployBundles(List<File> var1, boolean var2) throws BundleException;

    @Deprecated
    default public void undeployBundle(String bundleName) throws BundleException {
        this.undeployBundle(bundleName, false);
    }

    @Deprecated
    default public void undeployBundle(String bundleName, boolean reloadResources) throws BundleException {
        this.undeployBundles(Collections.singletonList(bundleName), reloadResources);
    }

    @Deprecated
    default public void undeployBundles(List<String> bundleNames) throws BundleException {
        this.undeployBundles(bundleNames, false);
    }

    @Deprecated
    public void undeployBundles(List<String> var1, boolean var2) throws BundleException;

    public ReloadResult reloadBundles(ReloadContext var1) throws BundleException;

    public void runDeploymentPreprocessor() throws IOException;

    @Deprecated
    public void installWebResources(File var1) throws IOException;

    public String getOSGIBundleName(File var1);
}

