/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="versions", type="VersionService", targetType="Document", targetFacets={"Versionable"})
public class VersionService
extends DefaultAdapter {
    @GET
    public Object doGet() {
        return this.getTarget().getView("versions");
    }

    @Path(value="last")
    public DocumentObject getLastVersion() {
        DocumentObject dobj = (DocumentObject)this.getTarget();
        DocumentModel doc = dobj.getDocument();
        DocumentModel v = dobj.getCoreSession().getLastDocumentVersion(doc.getRef());
        if (v != null) {
            return dobj.newDocument(v);
        }
        throw new WebResourceNotFoundException("No version found for " + ((DocumentObject)this.getTarget()).getDocument().getPath());
    }

    @Path(value="{label}")
    public DocumentObject getVersion(@PathParam(value="label") String label) {
        DocumentObject dobj = (DocumentObject)this.getTarget();
        DocumentModel doc = dobj.getDocument();
        List versions = dobj.getCoreSession().getVersionsForDocument(doc.getRef());
        for (VersionModel v : versions) {
            if (!label.equals(v.getLabel())) continue;
            return dobj.newDocument(dobj.getCoreSession().getDocumentWithVersion(doc.getRef(), v));
        }
        throw new WebResourceNotFoundException("No such version " + label + " for document" + this.getTarget().getPath());
    }

    @POST
    public Object doPost() {
        return null;
    }
}

