/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.info;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.ProductionState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="package")
@XmlType(propOrder={"id", "state", "version", "name", "type", "visibility", "targetPlatforms", "vendor", "supportsHotReload", "supported", "productionState", "validationState", "provides", "dependencies", "conflicts", "title", "description", "homePage", "licenseType", "licenseUrl", "templates"})
public class PackageInfo {
    public String name;
    public String version;
    public String id;
    public PackageState state;
    public String title;
    public String description;
    public String homePage;
    public String licenseType;
    public String licenseUrl;
    public ProductionState productionState;
    public NuxeoValidationState validationState;
    public String[] targetPlatforms;
    public PackageType type;
    public String vendor;
    public PackageVisibility visibility;
    public PackageDependency[] provides;
    public PackageDependency[] dependencies;
    public PackageDependency[] conflicts;
    public boolean supportsHotReload;
    public boolean supported;
    public Set<String> templates;

    public PackageInfo() {
    }

    public PackageInfo(Package pkg) {
        this.name = pkg.getName();
        this.version = pkg.getVersion().toString();
        this.id = pkg.getId();
        this.state = pkg.getPackageState();
        this.title = pkg.getTitle();
        this.description = pkg.getDescription();
        this.homePage = pkg.getHomePage();
        this.licenseType = pkg.getLicenseType();
        this.licenseUrl = pkg.getLicenseUrl();
        this.productionState = pkg.getProductionState();
        this.validationState = pkg.getValidationState();
        this.targetPlatforms = pkg.getTargetPlatforms();
        this.type = pkg.getType();
        this.vendor = pkg.getVendor();
        this.visibility = pkg.getVisibility();
        if (this.visibility == null) {
            this.visibility = PackageVisibility.UNKNOWN;
        }
        this.provides = pkg.getProvides();
        this.dependencies = pkg.getDependencies();
        this.conflicts = pkg.getConflicts();
        this.supportsHotReload = pkg.supportsHotReload();
        this.supported = pkg.isSupported();
        this.templates = this.templates(pkg);
    }

    private Set<String> templates(Package pkg) {
        if (!(pkg instanceof LocalPackage)) {
            return Collections.emptySet();
        }
        HashSet<String> templatesFound = new HashSet<String>();
        try {
            File installFile = ((LocalPackage)pkg).getInstallFile();
            if (!installFile.exists()) {
                return Collections.emptySet();
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(installFile);
            NodeList nodes = dom.getDocumentElement().getElementsByTagName("config");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element node = (Element)nodes.item(i);
                if (!node.hasAttribute("addtemplate")) continue;
                StringTokenizer tokenizer = new StringTokenizer(node.getAttribute("addtemplate"), ",");
                while (tokenizer.hasMoreTokens()) {
                    templatesFound.add(tokenizer.nextToken());
                }
            }
        }
        catch (IOException | ParserConfigurationException | PackageException | SAXException e) {
            LogFactory.getLog(PackageInfo.class).warn((Object)("Could not parse install file for " + pkg.getName()), e);
        }
        return templatesFound;
    }
}

