/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class MobileBannerHelper {
    public static final String PROTOCOL_PROPERTY = "nuxeo.mobile.application.protocol";
    public static final String ANDROID_PACKAGE_PROPERTY = "nuxeo.mobile.application.android.package";
    public static final String ITUNES_ID_PROPERTY = "nuxeo.mobile.application.iTunesId";
    public static final String ANDROID_PROTOCOL_SCHEME = "android-app";
    public static final String ITUNES_URL = "https://itunes.apple.com/app/";

    public static String getURLForAndroidApplication(HttpServletRequest request) {
        return MobileBannerHelper.getURLForAndroidApplication(request, null);
    }

    public static String getURLForAndroidApplication(HttpServletRequest request, DocumentModel doc) {
        return MobileBannerHelper.getURLForMobileApplication(MobileBannerHelper.getAndroidProtocol(), request, doc);
    }

    public static String getURLForIOSApplication(HttpServletRequest request) {
        return MobileBannerHelper.getURLForIOSApplication(request, null);
    }

    public static String getURLForIOSApplication(HttpServletRequest request, DocumentModel doc) {
        return MobileBannerHelper.getURLForMobileApplication(MobileBannerHelper.getIOSProtocol(), request, doc);
    }

    public static String getAppStoreURL() {
        return ITUNES_URL + Framework.getProperty((String)ITUNES_ID_PROPERTY);
    }

    public static String getAndroidProtocol() {
        return String.format("%s://%s/%s/", ANDROID_PROTOCOL_SCHEME, Framework.getProperty((String)ANDROID_PACKAGE_PROPERTY), Framework.getProperty((String)PROTOCOL_PROPERTY));
    }

    public static String getIOSProtocol() {
        return String.format("%s://", Framework.getProperty((String)PROTOCOL_PROPERTY));
    }

    public static String getURLForMobileApplication(String protocol, HttpServletRequest request, DocumentModel doc) {
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)request);
        String requestedURL = request.getParameter("requestedUrl");
        return MobileBannerHelper.getURLForMobileApplication(protocol, baseURL, doc, requestedURL);
    }

    public static String getURLForMobileApplication(String protocol, String baseURL, DocumentModel doc, String requestedURL) {
        String url = protocol + MobileBannerHelper.getServerPart(baseURL);
        if (doc != null) {
            return url + MobileBannerHelper.getDocumentPart(doc);
        }
        if (StringUtils.isNotBlank((String)requestedURL)) {
            return url + MobileBannerHelper.getDocumentPart(requestedURL);
        }
        return url;
    }

    protected static String getServerPart(String baseURL) {
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL.replaceAll("://", "/");
    }

    protected static String getDocumentPart(DocumentModel doc) {
        return doc.getRepositoryName() + "/id/" + doc.getId();
    }

    protected static String getDocumentPart(String requestedURL) {
        String serverName;
        DocumentLocation docLoc;
        String docPart = "";
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        DocumentView docView = documentViewCodecManager.getDocumentViewFromUrl(requestedURL, false, null);
        if (docView != null && (docLoc = docView.getDocumentLocation()) != null && (serverName = docLoc.getServerName()) != null) {
            docPart = docPart + serverName;
            IdRef idRef = docLoc.getIdRef();
            PathRef pathRef = docLoc.getPathRef();
            if (idRef != null) {
                docPart = docPart + "/id/" + idRef;
            } else if (pathRef != null) {
                docPart = docPart + "/path" + pathRef;
            }
        }
        return docPart;
    }
}

