/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.cache.SimpleCacheFilter;
import org.nuxeo.ecm.platform.web.common.ajax.service.AjaxProxyService;
import org.nuxeo.ecm.platform.web.common.ajax.service.ProxyURLConfigEntry;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.LRUCachingMap;
import org.nuxeo.runtime.api.Framework;

public class AjaxProxyServlet
extends HttpServlet {
    public static final String X_METHOD_HEADER = "X-Requested-Method";
    protected static Map<String, String> requestsCache = new LRUCachingMap<String, String>(250);
    protected static final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AjaxProxyServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AjaxProxyServlet.handleProxy(req.getMethod(), req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AjaxProxyServlet.handleProxy(req.getHeader(X_METHOD_HEADER), req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AjaxProxyServlet.handleProxy(req.getMethod(), req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleProxy(String method, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String targetURL;
        String requestType = req.getParameter("type");
        if (requestType == null) {
            requestType = "text";
        }
        if ((targetURL = req.getParameter("url")) == null) {
            return;
        }
        String cache = req.getParameter("cache");
        ProxyURLConfigEntry entry = ((AjaxProxyService)Framework.getService(AjaxProxyService.class)).getConfigForURL(targetURL);
        if (entry == null || !entry.isGranted()) {
            resp.sendError(403);
            log.warn((Object)("client requested proxying for unauthorized url " + targetURL));
            return;
        }
        String body = null;
        String cacheKey = targetURL;
        if (entry.useCache()) {
            if (entry.useCache()) {
                cacheKey = cacheKey + AjaxProxyServlet.getSessionId(req);
            }
            try {
                cacheLock.readLock().lock();
                body = requestsCache.get(cacheKey);
            }
            finally {
                cacheLock.readLock().unlock();
            }
        }
        boolean foundInCache = true;
        if (body == null) {
            foundInCache = false;
            body = AjaxProxyServlet.doRequest(method, targetURL, req);
        }
        if (!foundInCache && entry.useCache()) {
            try {
                cacheLock.writeLock().lock();
                requestsCache.put(cacheKey, body);
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
        if (requestType.equals("text")) {
            resp.setContentType("text/plain");
        } else if (requestType.equals("xml")) {
            resp.setContentType("text/xml");
        }
        if (cache != null) {
            SimpleCacheFilter.addCacheHeader(resp, cache);
        }
        resp.getWriter().write(body);
        resp.setStatus(200);
    }

    protected static String getSessionId(HttpServletRequest req) {
        String jSessionId = null;
        for (Cookie cookie : req.getCookies()) {
            if (!"JSESSIONID".equalsIgnoreCase(cookie.getName())) continue;
            jSessionId = cookie.getValue();
            break;
        }
        return jSessionId;
    }

    /*
     * Exception decompiling
     */
    protected static String doRequest(String method, String targetURL, HttpServletRequest req) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

