/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.ajax.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.ajax.service.AjaxProxyService;
import org.nuxeo.ecm.platform.web.common.ajax.service.ProxyURLConfigEntry;
import org.nuxeo.ecm.platform.web.common.ajax.service.ProxyableURLDescriptor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.LRUCachingMap;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AjaxProxyComponent
extends DefaultComponent
implements AjaxProxyService {
    public static final String PROXY_URL_EP = "proxyableURL";
    protected static final Map<String, ProxyableURLDescriptor> urlDescriptors = new HashMap<String, ProxyableURLDescriptor>();
    protected static final Map<String, ProxyURLConfigEntry> urlCache = new LRUCachingMap<String, ProxyURLConfigEntry>(250);
    protected static final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(AjaxProxyComponent.class);

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROXY_URL_EP.equals(extensionPoint)) {
            ProxyableURLDescriptor desc = (ProxyableURLDescriptor)contribution;
            this.registerProxyURL(desc);
        } else {
            log.error((Object)("Unknown ExtensionPoint " + extensionPoint));
        }
    }

    protected void registerProxyURL(ProxyableURLDescriptor desc) {
        if (urlDescriptors.containsKey(desc.getName())) {
            urlDescriptors.get(desc.getName()).merge(desc);
        } else {
            urlDescriptors.put(desc.getName(), desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyURLConfigEntry getConfigForURL(String targetUrl) {
        ProxyURLConfigEntry entry = null;
        try {
            cacheLock.readLock().lock();
            entry = urlCache.get(targetUrl);
        }
        finally {
            cacheLock.readLock().unlock();
        }
        if (entry == null) {
            entry = this.computeConfigForURL(targetUrl);
            try {
                cacheLock.writeLock().lock();
                urlCache.put(targetUrl, entry);
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
        return entry;
    }

    public ProxyURLConfigEntry computeConfigForURL(String targetUrl) {
        for (ProxyableURLDescriptor desc : urlDescriptors.values()) {
            Pattern pat;
            Matcher m;
            if (!desc.isEnabled() || !(m = (pat = desc.getCompiledPattern()).matcher(targetUrl)).matches()) continue;
            return new ProxyURLConfigEntry(true, desc);
        }
        return new ProxyURLConfigEntry();
    }
}

