/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.locale;

import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginScreenConfig;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;

public class DefaultLocaleProvider
implements LocaleProvider {
    @Override
    public Locale getLocale(CoreSession repo) {
        return this.getLocaleWithDefault(repo);
    }

    @Override
    public Locale getLocale(DocumentModel userProfileDoc) {
        return this.getLocaleWithDefault(userProfileDoc);
    }

    @Override
    public TimeZone getTimeZone(CoreSession repo) {
        return this.getDefaultTimezone();
    }

    @Override
    public Locale getLocaleWithDefault(CoreSession session) {
        return this.getDefaultLocale();
    }

    @Override
    public Locale getLocaleWithDefault(DocumentModel userProfileDoc) {
        return this.getDefaultLocale();
    }

    @Override
    public Locale getLocaleWithDefault(String requestedLocale) {
        Locale res = null;
        LoginScreenConfig screenConfig = LoginScreenHelper.getConfig();
        if (screenConfig != null) {
            List<String> supported = screenConfig.getSupportedLocales();
            res = !StringUtils.isBlank((CharSequence)requestedLocale) && supported.contains(requestedLocale) ? LocaleUtils.toLocale((String)requestedLocale) : LocaleUtils.toLocale((String)screenConfig.getDefaultLocale());
        }
        if (res == null) {
            return Locale.getDefault();
        }
        return res;
    }

    protected Locale getDefaultLocale() {
        return this.getLocaleWithDefault((String)null);
    }

    protected TimeZone getDefaultTimezone() {
        return TimeZone.getDefault();
    }
}

