/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.ooomanager;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class OOoState {
    public static final int STOPPED = 0;
    public static final int STARTING = 1;
    public static final int STARTED = 2;
    public static final int STOPPING = 3;
    protected volatile int status = 0;
    protected volatile CountDownLatch startLatch = null;

    public synchronized void update(int state) {
        if (state == 1) {
            this.startLatch = new CountDownLatch(1);
            this.status = 1;
        } else {
            this.status = state;
            if (this.startLatch != null) {
                this.startLatch.countDown();
                this.startLatch = null;
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isStarted() {
        return this.status == 2;
    }

    public boolean isStarting() {
        return this.status == 1;
    }

    public boolean isStopping() {
        return this.status == 3;
    }

    public boolean isStopped() {
        return this.status == 0;
    }

    public boolean isAlive() throws InterruptedException {
        return this.isAlive(60L, TimeUnit.SECONDS);
    }

    public boolean isAlive(long timeout, TimeUnit unit) throws InterruptedException {
        CountDownLatch latch = this.startLatch;
        if (latch != null) {
            latch.await(timeout, unit);
        }
        return this.status == 2;
    }
}

