/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.io.Serializable;
import java.security.Principal;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.NuxeoDriveContribException;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.impl.NuxeoDriveManagerImpl;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDriveFileSystemDeletionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(NuxeoDriveFileSystemDeletionListener.class);

    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if (doc.hasFacet("SystemDocument")) {
            return;
        }
        DocumentModel docForLogEntry = doc;
        if ("beforeDocumentModification".equals(event.getName()) && (docForLogEntry = this.handleBeforeDocUpdate(ctx, doc)) == null) {
            return;
        }
        if ("lifecycle_transition_event".equals(event.getName()) && !this.handleLifeCycleTransition(ctx)) {
            return;
        }
        if ("aboutToRemove".equals(event.getName()) && !this.handleAboutToRemove(doc)) {
            return;
        }
        String virtualEventName = "beforeDocumentSecurityModification".equals(event.getName()) ? "securityUpdated" : "deleted";
        String impactedUserName = (String)((Object)ctx.getProperty("impactedUserName"));
        this.fireVirtualEventLogEntry(docForLogEntry, virtualEventName, ctx.getPrincipal(), impactedUserName);
    }

    protected DocumentModel handleBeforeDocUpdate(DocumentEventContext ctx, DocumentModel doc) throws ClientException {
        BlobHolder bh;
        BlobHolder previousBh;
        boolean blobRemoved = false;
        DocumentModel previousDoc = (DocumentModel)ctx.getProperty("previousDocumentModel");
        if (previousDoc != null && (previousBh = (BlobHolder)previousDoc.getAdapter(BlobHolder.class)) != null && (bh = (BlobHolder)doc.getAdapter(BlobHolder.class)) != null) {
            boolean bl = blobRemoved = previousBh.getBlob() != null && bh.getBlob() == null;
        }
        if (blobRemoved) {
            return previousDoc;
        }
        return null;
    }

    protected boolean handleLifeCycleTransition(DocumentEventContext ctx) throws ClientException {
        String transition = (String)((Object)ctx.getProperty("transition"));
        return transition != null && "delete".equals(transition);
    }

    protected boolean handleAboutToRemove(DocumentModel doc) throws ClientException {
        return !"deleted".equals(doc.getCurrentLifeCycleState());
    }

    protected void fireVirtualEventLogEntry(DocumentModel doc, String eventName, Principal principal, String impactedUserName) {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger == null) {
            return;
        }
        FileSystemItem fsItem = null;
        try {
            fsItem = ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, true, true);
        }
        catch (RootlessItemException e) {
            return;
        }
        catch (NuxeoDriveContribException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Either Nuxeo Drive contributions are missing or the FileSystemItemAdapterService component is not ready (application has nor started yet) => ignoring event '%s'.", eventName));
            }
            return;
        }
        if (fsItem == null) {
            return;
        }
        LogEntry entry = logger.newLogEntry();
        entry.setEventId(eventName);
        entry.setEventDate(Calendar.getInstance(NuxeoDriveManagerImpl.UTC).getTime());
        entry.setCategory((String)((Object)NuxeoDriveEvents.EVENT_CATEGORY));
        entry.setDocUUID(doc.getId());
        entry.setDocPath(doc.getPathAsString());
        entry.setPrincipalName(principal.getName());
        entry.setDocType(doc.getType());
        entry.setRepositoryId(doc.getRepositoryName());
        entry.setDocLifeCycle(doc.getCurrentLifeCycleState());
        HashMap<String, ExtendedInfo> extendedInfos = new HashMap<String, ExtendedInfo>();
        if (impactedUserName != null) {
            extendedInfos.put("impactedUserName", logger.newExtendedInfo((Serializable)((Object)impactedUserName)));
        }
        extendedInfos.put("fileSystemItemId", logger.newExtendedInfo((Serializable)((Object)fsItem.getId())));
        extendedInfos.put("fileSystemItemName", logger.newExtendedInfo((Serializable)((Object)fsItem.getName())));
        entry.setExtendedInfos(extendedInfos);
        EventContextImpl eventContext = new EventContextImpl(new Object[]{entry});
        Event event = eventContext.newEvent("virtualEventCreated");
        ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
    }
}

